# chat-server-connector
Mentortools service for chatting

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0+2042681569
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import chat_server_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import chat_server_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import chat_server_connector
from chat_server_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = chat_server_connector.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: APIKeyHeader
configuration.api_key['APIKeyHeader'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['APIKeyHeader'] = 'Bearer'

# Configure Bearer authorization: HTTPBearer
configuration = chat_server_connector.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
async with chat_server_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = chat_server_connector.ChatSettingsApi(api_client)

    try:
        # Settings Get
        api_response = await api_instance.chat_settings_settings_get()
        print("The response of ChatSettingsApi->chat_settings_settings_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ChatSettingsApi->chat_settings_settings_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ChatSettingsApi* | [**chat_settings_settings_get**](docs/ChatSettingsApi.md#chat_settings_settings_get) | **GET** /settings/v1/ | Settings Get
*ChatSettingsApi* | [**chat_settings_settings_set**](docs/ChatSettingsApi.md#chat_settings_settings_set) | **PUT** /settings/v1/ | Settings Set
*ChatsApi* | [**chats_chat_delete**](docs/ChatsApi.md#chats_chat_delete) | **DELETE** /chats/v1/{chat_id} | Chat Delete
*ChatsApi* | [**chats_chat_get**](docs/ChatsApi.md#chats_chat_get) | **GET** /chats/v1/{chat_id} | Chat Get
*ChatsApi* | [**chats_chat_join**](docs/ChatsApi.md#chats_chat_join) | **POST** /chats/v1/{chat_id}/join | Chat Join
*ChatsApi* | [**chats_chat_leave**](docs/ChatsApi.md#chats_chat_leave) | **POST** /chats/v1/{chat_id}/leave | Chat Leave
*ChatsApi* | [**chats_chat_mark_as_read**](docs/ChatsApi.md#chats_chat_mark_as_read) | **POST** /chats/v1/{chat_id}/mark_as_read | Chat Mark As Read
*ChatsApi* | [**chats_chat_member_ban**](docs/ChatsApi.md#chats_chat_member_ban) | **POST** /chats/v1/{chat_id}/members/{user_id}/ban | Chat Member Ban
*ChatsApi* | [**chats_chat_members_list**](docs/ChatsApi.md#chats_chat_members_list) | **GET** /chats/v1/{chat_id}/members | Chat Members List
*ChatsApi* | [**chats_chat_members_update**](docs/ChatsApi.md#chats_chat_members_update) | **PATCH** /chats/v1/{chat_id}/members | Chat Members Update
*ChatsApi* | [**chats_chat_message_delete**](docs/ChatsApi.md#chats_chat_message_delete) | **DELETE** /chats/v1/{chat_id}/messages/{message_id} | Chat Message Delete
*ChatsApi* | [**chats_chat_message_get**](docs/ChatsApi.md#chats_chat_message_get) | **GET** /chats/v1/{chat_id}/messages/{message_id} | Chat Message Get
*ChatsApi* | [**chats_chat_messages_add**](docs/ChatsApi.md#chats_chat_messages_add) | **POST** /chats/v1/{chat_id}/messages | Chat Messages Add
*ChatsApi* | [**chats_chat_messages_list**](docs/ChatsApi.md#chats_chat_messages_list) | **GET** /chats/v1/{chat_id}/messages | Chat Messages List
*ChatsApi* | [**chats_chat_mute**](docs/ChatsApi.md#chats_chat_mute) | **POST** /chats/v1/{chat_id}/mute | Chat Mute
*ChatsApi* | [**chats_chat_private_join**](docs/ChatsApi.md#chats_chat_private_join) | **POST** /chats/v1/private/{chat_uuid}/join | Chat Private Join
*ChatsApi* | [**chats_chat_unmute**](docs/ChatsApi.md#chats_chat_unmute) | **POST** /chats/v1/{chat_id}/unmute | Chat Unmute
*ChatsApi* | [**chats_chat_update**](docs/ChatsApi.md#chats_chat_update) | **PUT** /chats/v1/{chat_id} | Chat Update
*ChatsApi* | [**chats_chats_add**](docs/ChatsApi.md#chats_chats_add) | **POST** /chats/v1/ | Chats Add
*ChatsApi* | [**chats_chats_list**](docs/ChatsApi.md#chats_chats_list) | **GET** /chats/v1/ | Chats List
*ChatsApi* | [**chats_chats_list_available**](docs/ChatsApi.md#chats_chats_list_available) | **GET** /chats/v1/available | Chats List Available
*ChatsApi* | [**chats_get_total_unread_messages**](docs/ChatsApi.md#chats_get_total_unread_messages) | **GET** /chats/v1/unread/count | Get Total Unread Messages
*ContactsApi* | [**contacts_contact_chat_get**](docs/ContactsApi.md#contacts_contact_chat_get) | **GET** /contacts/v1/{user_id}/chat | Contact Chat Get
*ContactsApi* | [**contacts_contact_chat_get_or_create**](docs/ContactsApi.md#contacts_contact_chat_get_or_create) | **PUT** /contacts/v1/{user_id}/chat | Contact Chat Get Or Create
*ContactsApi* | [**contacts_contact_get**](docs/ContactsApi.md#contacts_contact_get) | **GET** /contacts/v1/{user_id} | Contact Get
*ContactsApi* | [**contacts_contacts_list**](docs/ContactsApi.md#contacts_contacts_list) | **GET** /contacts/v1/ | Contacts List
*DefaultApi* | [**default_health_check**](docs/DefaultApi.md#default_health_check) | **GET** / | Health Check


## Documentation For Models

 - [ChatGetWithMembersAndMessages](docs/ChatGetWithMembersAndMessages.md)
 - [ChatListGet](docs/ChatListGet.md)
 - [ChatMemberCreateOrUpdate](docs/ChatMemberCreateOrUpdate.md)
 - [ChatMemberGet](docs/ChatMemberGet.md)
 - [ChatMemberRole](docs/ChatMemberRole.md)
 - [ChatMemberRoleAdd](docs/ChatMemberRoleAdd.md)
 - [ChatMessage](docs/ChatMessage.md)
 - [ChatMessageCreate](docs/ChatMessageCreate.md)
 - [ChatMessageRead](docs/ChatMessageRead.md)
 - [ChatNew](docs/ChatNew.md)
 - [ChatSettingsCreateOrUpdate](docs/ChatSettingsCreateOrUpdate.md)
 - [ChatSettingsGet](docs/ChatSettingsGet.md)
 - [ChatType](docs/ChatType.md)
 - [ChatUpdate](docs/ChatUpdate.md)
 - [Contact](docs/Contact.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [ResponseWrapper](docs/ResponseWrapper.md)
 - [ResponseWrapperBool](docs/ResponseWrapperBool.md)
 - [ResponseWrapperChatGetWithMembersAndMessages](docs/ResponseWrapperChatGetWithMembersAndMessages.md)
 - [ResponseWrapperChatMessage](docs/ResponseWrapperChatMessage.md)
 - [ResponseWrapperChatSettingsGet](docs/ResponseWrapperChatSettingsGet.md)
 - [ResponseWrapperContact](docs/ResponseWrapperContact.md)
 - [ResponseWrapperInt](docs/ResponseWrapperInt.md)
 - [ResponseWrapperListChatListGet](docs/ResponseWrapperListChatListGet.md)
 - [ResponseWrapperListChatMemberGet](docs/ResponseWrapperListChatMemberGet.md)
 - [ResponseWrapperListChatMessageRead](docs/ResponseWrapperListChatMessageRead.md)
 - [ResponseWrapperListContact](docs/ResponseWrapperListContact.md)
 - [Result](docs/Result.md)
 - [RoleEnum](docs/RoleEnum.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication

<a id="APIKeyHeader"></a>
### APIKeyHeader

- **Type**: API key
- **API key parameter name**: server_name
- **Location**: HTTP header


## Author




