#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
from dataclasses import dataclass
from typing import ClassVar

from http_tools import ContentType

from .body_parameter import BodyParameter


@dataclass(frozen=True, kw_only=True)
class JsonWholeBodyParameter(BodyParameter, abc.ABC):
    body_mime_type: ClassVar[ContentType] = ContentType.Json

    def __init__(self):
        raise NotImplementedError("requires inheritance restructuration")
