#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import enum


class SchemaFormat(enum.StrEnum):
    pass


class IntegerSchemaFormat(SchemaFormat):
    int32 = 'int32'  # signed 32 bits integer
    int64 = 'int64'  # signed 64 bits integer


class NumberSchemaFormat(SchemaFormat):
    float = 'float'  # signed 32 bits float
    double = 'double'  # signed 64 bits float


class StringSchemaFormat(SchemaFormat):
    date = 'date'  # YYYY-MM-DD: "1970-01-01" / "2025-07-01"
    time = 'time'  # hh:mm:ss.sTZD: "10:05:08" / "10:05:08.5" / "10:05:08-02:30" / "10:05:08Z"
    date_time = 'date-time'  # YYYY-MM-DDThh:mm:ss.sTZD:
    # "1970-01-01T10:05:08" / "2025-07-01T10:05:08.10" / "2025-07-01T10:05:08+01:00"
    duration = 'duration'  # ISO 8601: "P4DT12H30M5S"
    regex = 'regex'  # valid re: "^[a-z]+$"
    email = 'email'  # ascii email: "john@example.com"
    idn_email = 'idn-email'  # Internationalized Domain Name email: "иван@иванов.ру"
    hostname = 'hostname'  # ascii hostname(could be encoded): "www.example.com" / "xn--4gbwdl.xn--wgbh1c"
    idn_hostname = 'idn-hostname'  # Internationalized Domain Name hostname: "иванов.ру"
    ipv4 = 'ipv4'  # ipv4: "192.168.0.1"
    ipv6 = 'ipv6'  # ipv6: "::1" / "2001:db8:3333:4444:5555:6666:7777:8888"
    json_pointer = 'json-pointer'  # absolute json pointer(starting with '/'): "/a/b/c"
    relative_json_pointer = 'relative-json-pointer'  # relative json pointer: "0/a/b" / "5/a/b#" / "2#"
    uri = 'uri'  # full ascii uri: "http://example.com/path?qs=v&qs2[1]=3#fragment" / "http://example.com/index.html"
    uri_reference = 'uri-reference'  # relative ascii uri: "aaa/bbb.html" / "?a=42" / "http://example.com/index.html"
    uri_template = 'uri-template'  # uri template: "/{+file}.html" / "{?q,lang}"
    iri = 'iri'  # Internationalized Resource Identifier: "http://иванов.ру"
    iri_reference = 'iri-reference'  # iri ref: "/иванов.ру" / "#фрагмент"
    uuid = 'uuid'  # any ver/case:  "2EB8AA08-AA98-11EA-B4AA-73B441D16380" / "2eb8aa08-aa98-11ea-b4aa-73b441d16380"
    # OpenAPI extension to JsonSchema formats
    password = 'password'  # A hint to UIs to obscure input.
    binary = 'binary'  # format for bytes
