#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mikhail Marokin <m.marokin@abm-jsc.ru>


from dataclasses import dataclass


@dataclass(frozen=True)
class ImageBox:
    id: int
    rtsp_url: str
    x_left_up_percentage: float
    x_right_bottom_percentage: float
    y_left_up_percentage: float
    y_right_bottom_percentage: float
    overexpose_area_percent_in_box: float
    created_at: float


@dataclass(frozen=True)
class OverexposeSettings:
    rtsp_url: str
    pixel_brightness_threshold: int
    box_min_area: int
    overexposed_percentage_threshold: int
    created_at: float
    image_boxes: list[ImageBox]
