import asyncio
from dataclasses import dataclass

import init_helpers
from async_tools import AsyncInitable, AsyncDeinitable
from file_storage.abstract_file_storage import AbstractFileStorage
from file_storage.disc_file_storage.disc_file_storage import DiscFileStorage
from http_tools import HttpServer
from sqlalchemy_tools.database_connector.abstract_database_connector import AbstractDatabaseConnector
from sqlalchemy_tools.database_connector.database_connector import DatabaseConnector

from .controller import Controller
from .database import Database
from .thumbnail.thumbnail_provider import ThumbnailProvider
from .http_handler import HttpHandler
from .thumbnail.image_thumbnail_procressor import ImageThumbnailProcessor

print("hi")
init_helpers.init_logs(init_helpers.LogsConfig())

async def main():
    # @dataclass
    # class Config:
    #     max_thumbnail_creation_processes: int = 5
    #     max_files_in_archive: int = 100
    #     max_total_archive_size_bytes: int = 100 * 1024 * 1024
    @dataclass
    class Context(AsyncInitable, AsyncDeinitable):
        http_server: HttpServer = None
        database_connector: AbstractDatabaseConnector = None
        database: Database = None
        # zipper: MemoryZipper = None
        file_storage: AbstractFileStorage = None
        thumbnail_provider: ThumbnailProvider = None
        controller: Controller = None

        def __post_init__(self) -> None:
            AsyncInitable.__init__(self)
            AsyncDeinitable.__init__(self)

    context = Context()
    context.http_server = HttpServer(HttpServer.Config(port=2837), HttpServer.Context(instance_id="module"))
    context.database_connector = DatabaseConnector(DatabaseConnector.Config(
        address="postgresql://postgres:0064789@10.31.146.9/saferegion_file_storage"))
    context.database = Database(context)
    context.file_storage = DiscFileStorage(DiscFileStorage.Config(location="/tmp/saferegion_file_storage"))
    context.thumbnail_provider = ThumbnailProvider(ThumbnailProvider.Config(),
                                                   ImageThumbnailProcessor(ImageThumbnailProcessor.Config()))
    # context.zipper = MemoryZipper(MemoryZipper.Config())
    context.controller = Controller(Controller.Config(), context)
    context.http_handler = HttpHandler(context)

    print("start init")
    await context.async_init()
    print("init done")
    await asyncio.sleep(10 ** 10)

asyncio.run(main())