from dataclasses import dataclass, field
from enum import unique, StrEnum
from typing import Union


@unique
class PreprocessorOperator(StrEnum):
    JSON_GET = "get_from_json"


@dataclass
class Preprocessor:
    attribute: Union[str, 'Preprocessor']
    operator: PreprocessorOperator


@dataclass
class PreprocessorJsonGet(Preprocessor):
    operator: PreprocessorOperator = field(init=False, default=PreprocessorOperator.JSON_GET)
    keys: Union[str, list[str]]
