# coding: utf-8

"""
    Mentortools Team Member Server

    Mentortools service for Team Members

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic import Field, StrictStr

from typing import Optional

from team_member_server_sdk.models.add_team_member_role_request import AddTeamMemberRoleRequest
from team_member_server_sdk.models.remove_team_member_role_request import RemoveTeamMemberRoleRequest
from team_member_server_sdk.models.update_team_member_role_actions_request import UpdateTeamMemberRoleActionsRequest
from team_member_server_sdk.models.update_team_member_role_request import UpdateTeamMemberRoleRequest
from team_member_server_sdk.models.wrapped_response_list_team_member_role_response import WrappedResponseListTeamMemberRoleResponse
from team_member_server_sdk.models.wrapped_response_team_member_role_response import WrappedResponseTeamMemberRoleResponse

from team_member_server_sdk.api_client import ApiClient
from team_member_server_sdk.api_response import ApiResponse
from team_member_server_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TeamMemberRoleApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    async def add_team_member_role_v1_team_member_role_add_post(self, add_team_member_role_request : AddTeamMemberRoleRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseTeamMemberRoleResponse:  # noqa: E501
        """Add Team Member role  # noqa: E501

        This endpoint allow to add custom Team Member roles. Allowed for Admins / Portal Owners  # noqa: E501

        :param add_team_member_role_request: (required)
        :type add_team_member_role_request: AddTeamMemberRoleRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseTeamMemberRoleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the add_team_member_role_v1_team_member_role_add_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.add_team_member_role_v1_team_member_role_add_post_with_http_info(add_team_member_role_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def add_team_member_role_v1_team_member_role_add_post_with_http_info(self, add_team_member_role_request : AddTeamMemberRoleRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Add Team Member role  # noqa: E501

        This endpoint allow to add custom Team Member roles. Allowed for Admins / Portal Owners  # noqa: E501

        :param add_team_member_role_request: (required)
        :type add_team_member_role_request: AddTeamMemberRoleRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseTeamMemberRoleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'add_team_member_role_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_team_member_role_v1_team_member_role_add_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['add_team_member_role_request'] is not None:
            _body_params = _params['add_team_member_role_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseTeamMemberRoleResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/role/add', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def get_team_member_roles_v1_team_member_role_list_post(self, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseListTeamMemberRoleResponse:  # noqa: E501
        """Get Team Member roles  # noqa: E501

        This endpoint returns list of Team Member roles. Allowed for Admins / Portal Owners  # noqa: E501

        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseListTeamMemberRoleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_team_member_roles_v1_team_member_role_list_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.get_team_member_roles_v1_team_member_role_list_post_with_http_info(origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def get_team_member_roles_v1_team_member_role_list_post_with_http_info(self, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Team Member roles  # noqa: E501

        This endpoint returns list of Team Member roles. Allowed for Admins / Portal Owners  # noqa: E501

        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseListTeamMemberRoleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_team_member_roles_v1_team_member_role_list_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseListTeamMemberRoleResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/role/list', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def remove_team_member_role_v1_team_member_role_delete_post(self, remove_team_member_role_request : RemoveTeamMemberRoleRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseTeamMemberRoleResponse:  # noqa: E501
        """Remove Team Member role  # noqa: E501

        This endpoint allow to remove Team Member roles. Allowed for Admins / Portal Owners  # noqa: E501

        :param remove_team_member_role_request: (required)
        :type remove_team_member_role_request: RemoveTeamMemberRoleRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseTeamMemberRoleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the remove_team_member_role_v1_team_member_role_delete_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.remove_team_member_role_v1_team_member_role_delete_post_with_http_info(remove_team_member_role_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def remove_team_member_role_v1_team_member_role_delete_post_with_http_info(self, remove_team_member_role_request : RemoveTeamMemberRoleRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Remove Team Member role  # noqa: E501

        This endpoint allow to remove Team Member roles. Allowed for Admins / Portal Owners  # noqa: E501

        :param remove_team_member_role_request: (required)
        :type remove_team_member_role_request: RemoveTeamMemberRoleRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseTeamMemberRoleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'remove_team_member_role_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_team_member_role_v1_team_member_role_delete_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['remove_team_member_role_request'] is not None:
            _body_params = _params['remove_team_member_role_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseTeamMemberRoleResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/role/delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def update_team_member_role_actions_v1_team_member_role_action_update_post(self, update_team_member_role_actions_request : UpdateTeamMemberRoleActionsRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseTeamMemberRoleResponse:  # noqa: E501
        """Update Team Member role actions  # noqa: E501

        This endpoint allow to update Team Member role actions. Allowed for Admins / Portal Owners  # noqa: E501

        :param update_team_member_role_actions_request: (required)
        :type update_team_member_role_actions_request: UpdateTeamMemberRoleActionsRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseTeamMemberRoleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_team_member_role_actions_v1_team_member_role_action_update_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.update_team_member_role_actions_v1_team_member_role_action_update_post_with_http_info(update_team_member_role_actions_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def update_team_member_role_actions_v1_team_member_role_action_update_post_with_http_info(self, update_team_member_role_actions_request : UpdateTeamMemberRoleActionsRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Update Team Member role actions  # noqa: E501

        This endpoint allow to update Team Member role actions. Allowed for Admins / Portal Owners  # noqa: E501

        :param update_team_member_role_actions_request: (required)
        :type update_team_member_role_actions_request: UpdateTeamMemberRoleActionsRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseTeamMemberRoleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'update_team_member_role_actions_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_team_member_role_actions_v1_team_member_role_action_update_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_team_member_role_actions_request'] is not None:
            _body_params = _params['update_team_member_role_actions_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseTeamMemberRoleResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/role/action/update', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def update_team_member_role_v1_team_member_role_update_post(self, update_team_member_role_request : UpdateTeamMemberRoleRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseTeamMemberRoleResponse:  # noqa: E501
        """Update Team Member role  # noqa: E501

        This endpoint allow to update Team Member roles. Allowed for Admins / Portal Owners  # noqa: E501

        :param update_team_member_role_request: (required)
        :type update_team_member_role_request: UpdateTeamMemberRoleRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseTeamMemberRoleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_team_member_role_v1_team_member_role_update_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.update_team_member_role_v1_team_member_role_update_post_with_http_info(update_team_member_role_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def update_team_member_role_v1_team_member_role_update_post_with_http_info(self, update_team_member_role_request : UpdateTeamMemberRoleRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Update Team Member role  # noqa: E501

        This endpoint allow to update Team Member roles. Allowed for Admins / Portal Owners  # noqa: E501

        :param update_team_member_role_request: (required)
        :type update_team_member_role_request: UpdateTeamMemberRoleRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseTeamMemberRoleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'update_team_member_role_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_team_member_role_v1_team_member_role_update_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_team_member_role_request'] is not None:
            _body_params = _params['update_team_member_role_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseTeamMemberRoleResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/role/update', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
