#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>
from dataclasses import dataclass
from typing import Any

from init_helpers.dict_to_dataclass import convert_to_type


@dataclass
class EntityOrder:
    column: str
    ascending: bool = True


def entity_order_as_dict(order: EntityOrder) -> dict[str, Any]:
    return {key: convert_to_type(type_, key, getattr(order, key)) for key, type_ in EntityOrder.__annotations__.items()}
