# coding: utf-8

"""
    Mentortools Team Member Server

    Mentortools service for Team Members

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist

class TeamMemberRoleResponse(BaseModel):
    """
    TeamMemberRoleResponse
    """
    id: StrictInt = Field(...)
    portal_id: StrictInt = Field(...)
    title: StrictStr = Field(...)
    updated_at: Optional[StrictInt] = Field(...)
    created_at: StrictInt = Field(...)
    actions: conlist(StrictStr) = Field(...)
    allowed_course_ids: conlist(StrictInt) = Field(...)
    allowed_community_ids: conlist(StrictInt) = Field(...)
    __properties = ["id", "portal_id", "title", "updated_at", "created_at", "actions", "allowed_course_ids", "allowed_community_ids"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TeamMemberRoleResponse:
        """Create an instance of TeamMemberRoleResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if updated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.updated_at is None and "updated_at" in self.__fields_set__:
            _dict['updated_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TeamMemberRoleResponse:
        """Create an instance of TeamMemberRoleResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TeamMemberRoleResponse.parse_obj(obj)

        _obj = TeamMemberRoleResponse.parse_obj({
            "id": obj.get("id"),
            "portal_id": obj.get("portal_id"),
            "title": obj.get("title"),
            "updated_at": obj.get("updated_at"),
            "created_at": obj.get("created_at"),
            "actions": obj.get("actions"),
            "allowed_course_ids": obj.get("allowed_course_ids"),
            "allowed_community_ids": obj.get("allowed_community_ids")
        })
        return _obj


