#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Revva Konstantin <k.revva@abm-jsc.ru>

from dataclasses import dataclass
from typing import Any


@dataclass
class DefocusAnalyzeResult:
    rtsp_url: str
    snapshot_file_id: str
    snapshot_done_at: float
    reference_image_file_ids: list[str]
    detector_requests: list[dict[Any, Any]]
    detector_results: list[dict[Any, Any]]
    comparison_settings: dict[str, Any]
    comparison_results: list[float]
    result: float
    analyzed_at: float
