#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
from dataclasses import dataclass
from typing import Any, Sequence, Tuple


@dataclass
class PreproceededRecord:
    key: Any
    value: Any


@dataclass
class KafkaRecord:
    key: Any
    value: Any
    topic: str
    partition: int
    offset: int
    timestamp: int
    timestamp_type: int
    checksum: int
    serialized_key_size: int
    serialized_value_size: int
    headers: Sequence[Tuple[str, bytes]]
