from dataclasses import dataclass, field
from enum import Enum, unique
from typing import Any, Optional

from notification_server_connector.utils.current_timestamp import get_current_timestamp_ms


@unique
class SourceTypes(str, Enum):
    thread = 'thread'
    comment = 'comment'
    community_summary = 'community_summary'
    mobileapp_paid = 'mobileapp_paid'
    mobileapp_in_progress = 'mobileapp_in_progress'
    mobileapp_ready = 'mobileapp_ready'
    mobileapp_submit_facebook = 'mobileapp_submit_facebook'


@dataclass
class Notification:
    source_type_id: SourceTypes
    source_id: int
    portal_id: int
    portal_member_id: int
    title: str
    message: str = ''

    parent_id: Optional[int] = None
    parent_name: Optional[str] = None
    parent_portal_member_id: Optional[int] = None

    notification_receivers: list[int] = field(default_factory=list)

    created_at: int = field(default_factory=get_current_timestamp_ms)
    fcm_topic: Optional[str] = None

    args: Optional[dict[str, Any]] = None
    children: list["Notification"] = field(default_factory=list)
