# coding: utf-8

"""
    Mentortools

    Mentortools

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from pydantic import StrictStr

from typing import Optional

from google_connector.models.bundle_id_credentials import BundleIdCredentials
from google_connector.models.get_firebase_app_config_payload import GetFirebaseAppConfigPayload
from google_connector.models.project_id_credentials import ProjectIdCredentials
from google_connector.models.wrapped_response_android_versions import WrappedResponseAndroidVersions
from google_connector.models.wrapped_response_bool import WrappedResponseBool
from google_connector.models.wrapped_response_list_firebase_app_config_response import WrappedResponseListFirebaseAppConfigResponse
from google_connector.models.wrapped_response_list_iap_products import WrappedResponseListIAPProducts

from google_connector.api_client import ApiClient
from google_connector.api_response import ApiResponse
from google_connector.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CorrectProjectApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    async def setup_api_enable_api_services(self, project_id_credentials : ProjectIdCredentials, origin : Optional[StrictStr] = None, referer : Optional[StrictStr] = None, **kwargs) -> WrappedResponseBool:  # noqa: E501
        """Enable required Google Cloud APIs  # noqa: E501

        Enables necessary Google Cloud services (e.g., Android Publisher API, Service Usage API) for the specified project. Must be called before performing operations requiring API access.  # noqa: E501

        :param project_id_credentials: (required)
        :type project_id_credentials: ProjectIdCredentials
        :param origin:
        :type origin: str
        :param referer:
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the setup_api_enable_api_services_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.setup_api_enable_api_services_with_http_info(project_id_credentials, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def setup_api_enable_api_services_with_http_info(self, project_id_credentials : ProjectIdCredentials, origin : Optional[StrictStr] = None, referer : Optional[StrictStr] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Enable required Google Cloud APIs  # noqa: E501

        Enables necessary Google Cloud services (e.g., Android Publisher API, Service Usage API) for the specified project. Must be called before performing operations requiring API access.  # noqa: E501

        :param project_id_credentials: (required)
        :type project_id_credentials: ProjectIdCredentials
        :param origin:
        :type origin: str
        :param referer:
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id_credentials',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method setup_api_enable_api_services" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['Origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['Referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['project_id_credentials'] is not None:
            _body_params = _params['project_id_credentials']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseBool",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/correction/services/enable', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def setup_api_get_all_iap(self, bundle_id_credentials : BundleIdCredentials, origin : Optional[StrictStr] = None, referer : Optional[StrictStr] = None, **kwargs) -> WrappedResponseListIAPProducts:  # noqa: E501
        """List all in-app products  # noqa: E501

        Retrieves a complete list of in-app purchase (IAP) products associated with the given app. Requires valid Google Play Developer API credentials and bundle ID.  # noqa: E501

        :param bundle_id_credentials: (required)
        :type bundle_id_credentials: BundleIdCredentials
        :param origin:
        :type origin: str
        :param referer:
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseListIAPProducts
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the setup_api_get_all_iap_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.setup_api_get_all_iap_with_http_info(bundle_id_credentials, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def setup_api_get_all_iap_with_http_info(self, bundle_id_credentials : BundleIdCredentials, origin : Optional[StrictStr] = None, referer : Optional[StrictStr] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List all in-app products  # noqa: E501

        Retrieves a complete list of in-app purchase (IAP) products associated with the given app. Requires valid Google Play Developer API credentials and bundle ID.  # noqa: E501

        :param bundle_id_credentials: (required)
        :type bundle_id_credentials: BundleIdCredentials
        :param origin:
        :type origin: str
        :param referer:
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseListIAPProducts, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'bundle_id_credentials',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method setup_api_get_all_iap" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['Origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['Referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['bundle_id_credentials'] is not None:
            _body_params = _params['bundle_id_credentials']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseListIAPProducts",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/correction/iap/list', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def setup_api_get_app_configs(self, get_firebase_app_config_payload : GetFirebaseAppConfigPayload, origin : Optional[StrictStr] = None, referer : Optional[StrictStr] = None, **kwargs) -> WrappedResponseListFirebaseAppConfigResponse:  # noqa: E501
        """Get app configurations  # noqa: E501

        Retrieves Firebase app configuration json files for all apps in the project.  # noqa: E501

        :param get_firebase_app_config_payload: (required)
        :type get_firebase_app_config_payload: GetFirebaseAppConfigPayload
        :param origin:
        :type origin: str
        :param referer:
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseListFirebaseAppConfigResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the setup_api_get_app_configs_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.setup_api_get_app_configs_with_http_info(get_firebase_app_config_payload, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def setup_api_get_app_configs_with_http_info(self, get_firebase_app_config_payload : GetFirebaseAppConfigPayload, origin : Optional[StrictStr] = None, referer : Optional[StrictStr] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get app configurations  # noqa: E501

        Retrieves Firebase app configuration json files for all apps in the project.  # noqa: E501

        :param get_firebase_app_config_payload: (required)
        :type get_firebase_app_config_payload: GetFirebaseAppConfigPayload
        :param origin:
        :type origin: str
        :param referer:
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseListFirebaseAppConfigResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'get_firebase_app_config_payload',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method setup_api_get_app_configs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['Origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['Referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['get_firebase_app_config_payload'] is not None:
            _body_params = _params['get_firebase_app_config_payload']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseListFirebaseAppConfigResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/correction/firebase/app/config/list', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def setup_api_get_app_version(self, bundle_id_credentials : BundleIdCredentials, origin : Optional[StrictStr] = None, referer : Optional[StrictStr] = None, **kwargs) -> WrappedResponseAndroidVersions:  # noqa: E501
        """Get app version from Google Play  # noqa: E501

        Fetches version information for the specified Android app using its bundle ID and associated Google Play Developer API credentials. Useful for validating app versions and ensuring consistency across environments.  # noqa: E501

        :param bundle_id_credentials: (required)
        :type bundle_id_credentials: BundleIdCredentials
        :param origin:
        :type origin: str
        :param referer:
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseAndroidVersions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the setup_api_get_app_version_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.setup_api_get_app_version_with_http_info(bundle_id_credentials, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def setup_api_get_app_version_with_http_info(self, bundle_id_credentials : BundleIdCredentials, origin : Optional[StrictStr] = None, referer : Optional[StrictStr] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get app version from Google Play  # noqa: E501

        Fetches version information for the specified Android app using its bundle ID and associated Google Play Developer API credentials. Useful for validating app versions and ensuring consistency across environments.  # noqa: E501

        :param bundle_id_credentials: (required)
        :type bundle_id_credentials: BundleIdCredentials
        :param origin:
        :type origin: str
        :param referer:
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseAndroidVersions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'bundle_id_credentials',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method setup_api_get_app_version" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['Origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['Referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['bundle_id_credentials'] is not None:
            _body_params = _params['bundle_id_credentials']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseAndroidVersions",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/correction/app/version', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def setup_api_update_iam_policy(self, project_id_credentials : ProjectIdCredentials, origin : Optional[StrictStr] = None, referer : Optional[StrictStr] = None, **kwargs) -> WrappedResponseBool:  # noqa: E501
        """Update IAM policy for project  # noqa: E501

        Updates Identity and Access Management (IAM) policy bindings for the specified Google Cloud project. Used to grant or adjust access permissions for service accounts or users.  # noqa: E501

        :param project_id_credentials: (required)
        :type project_id_credentials: ProjectIdCredentials
        :param origin:
        :type origin: str
        :param referer:
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the setup_api_update_iam_policy_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.setup_api_update_iam_policy_with_http_info(project_id_credentials, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def setup_api_update_iam_policy_with_http_info(self, project_id_credentials : ProjectIdCredentials, origin : Optional[StrictStr] = None, referer : Optional[StrictStr] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Update IAM policy for project  # noqa: E501

        Updates Identity and Access Management (IAM) policy bindings for the specified Google Cloud project. Used to grant or adjust access permissions for service accounts or users.  # noqa: E501

        :param project_id_credentials: (required)
        :type project_id_credentials: ProjectIdCredentials
        :param origin:
        :type origin: str
        :param referer:
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id_credentials',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method setup_api_update_iam_policy" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['Origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['Referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['project_id_credentials'] is not None:
            _body_params = _params['project_id_credentials']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseBool",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/correction/iam_policy/update', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
