# lp-server-connector
Mentortools service for building and publishing landing pages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import lp_server_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import lp_server_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import lp_server_connector
from lp_server_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = lp_server_connector.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with lp_server_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = lp_server_connector.DefaultApi(api_client)

    try:
        # Health Check
        api_response = await api_instance.health_check_get()
        print("The response of DefaultApi->health_check_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->health_check_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**health_check_get**](docs/DefaultApi.md#health_check_get) | **GET** / | Health Check
*DefaultApi* | [**landings_add_v1_landings_post**](docs/DefaultApi.md#landings_add_v1_landings_post) | **POST** /v1/landings/ | Landings Add
*DefaultApi* | [**landings_delete_v1_landings_landing_id_delete**](docs/DefaultApi.md#landings_delete_v1_landings_landing_id_delete) | **DELETE** /v1/landings/{landing_id} | Landings Delete
*DefaultApi* | [**landings_duplicate_v1_landings_landing_id_duplicate_post**](docs/DefaultApi.md#landings_duplicate_v1_landings_landing_id_duplicate_post) | **POST** /v1/landings/{landing_id}/duplicate | Landings Duplicate
*DefaultApi* | [**landings_get_v1_landings_landing_id_get**](docs/DefaultApi.md#landings_get_v1_landings_landing_id_get) | **GET** /v1/landings/{landing_id} | Landings Get
*DefaultApi* | [**landings_group_update_v1_landings_patch**](docs/DefaultApi.md#landings_group_update_v1_landings_patch) | **PATCH** /v1/landings/ | Landings Group Update
*DefaultApi* | [**landings_history_count_v1_landings_landing_id_history_count_post**](docs/DefaultApi.md#landings_history_count_v1_landings_landing_id_history_count_post) | **POST** /v1/landings/{landing_id}/history/count | Landings History Count
*DefaultApi* | [**landings_history_one_v1_landings_landing_id_history_history_id_post**](docs/DefaultApi.md#landings_history_one_v1_landings_landing_id_history_history_id_post) | **POST** /v1/landings/{landing_id}/history/{history_id} | Landings History One
*DefaultApi* | [**landings_history_v1_landings_landing_id_history_post**](docs/DefaultApi.md#landings_history_v1_landings_landing_id_history_post) | **POST** /v1/landings/{landing_id}/history | Landings History
*DefaultApi* | [**landings_list_v1_landings_get**](docs/DefaultApi.md#landings_list_v1_landings_get) | **GET** /v1/landings/ | Landings List
*DefaultApi* | [**landings_publish_v1_landings_landing_id_publish_post**](docs/DefaultApi.md#landings_publish_v1_landings_landing_id_publish_post) | **POST** /v1/landings/{landing_id}/publish | Landings Publish
*DefaultApi* | [**landings_recover_v1_landings_landing_id_recover_post**](docs/DefaultApi.md#landings_recover_v1_landings_landing_id_recover_post) | **POST** /v1/landings/{landing_id}/recover | Landings Recover
*DefaultApi* | [**landings_unpublish_v1_landings_landing_id_unpublish_post**](docs/DefaultApi.md#landings_unpublish_v1_landings_landing_id_unpublish_post) | **POST** /v1/landings/{landing_id}/unpublish | Landings Unpublish
*DefaultApi* | [**landings_update_v1_landings_landing_id_post**](docs/DefaultApi.md#landings_update_v1_landings_landing_id_post) | **POST** /v1/landings/{landing_id} | Landings Update
*DefaultApi* | [**templates_add_v1_templates_post**](docs/DefaultApi.md#templates_add_v1_templates_post) | **POST** /v1/templates/ | Templates Add
*DefaultApi* | [**templates_count_v1_landings_count_get**](docs/DefaultApi.md#templates_count_v1_landings_count_get) | **GET** /v1/landings/count | Templates Count
*DefaultApi* | [**templates_count_v1_templates_count_get**](docs/DefaultApi.md#templates_count_v1_templates_count_get) | **GET** /v1/templates/count | Templates Count
*DefaultApi* | [**templates_delete_v1_templates_template_id_delete**](docs/DefaultApi.md#templates_delete_v1_templates_template_id_delete) | **DELETE** /v1/templates/{template_id} | Templates Delete
*DefaultApi* | [**templates_duplicate_v1_templates_template_id_duplicate_post**](docs/DefaultApi.md#templates_duplicate_v1_templates_template_id_duplicate_post) | **POST** /v1/templates/{template_id}/duplicate | Templates Duplicate
*DefaultApi* | [**templates_get_v1_templates_template_id_get**](docs/DefaultApi.md#templates_get_v1_templates_template_id_get) | **GET** /v1/templates/{template_id} | Templates Get
*DefaultApi* | [**templates_group_update_v1_templates_patch**](docs/DefaultApi.md#templates_group_update_v1_templates_patch) | **PATCH** /v1/templates/ | Templates Group Update
*DefaultApi* | [**templates_import_v1_templates_template_id_import_post**](docs/DefaultApi.md#templates_import_v1_templates_template_id_import_post) | **POST** /v1/templates/{template_id}/import | Templates Import
*DefaultApi* | [**templates_list_v1_templates_get**](docs/DefaultApi.md#templates_list_v1_templates_get) | **GET** /v1/templates/ | Templates List
*DefaultApi* | [**templates_publish_v1_templates_template_id_publish_post**](docs/DefaultApi.md#templates_publish_v1_templates_template_id_publish_post) | **POST** /v1/templates/{template_id}/publish | Templates Publish
*DefaultApi* | [**templates_recover_v1_templates_template_id_recover_post**](docs/DefaultApi.md#templates_recover_v1_templates_template_id_recover_post) | **POST** /v1/templates/{template_id}/recover | Templates Recover
*DefaultApi* | [**templates_unpublish_v1_templates_template_id_unpublish_post**](docs/DefaultApi.md#templates_unpublish_v1_templates_template_id_unpublish_post) | **POST** /v1/templates/{template_id}/unpublish | Templates Unpublish
*DefaultApi* | [**templates_update_v1_templates_template_id_post**](docs/DefaultApi.md#templates_update_v1_templates_template_id_post) | **POST** /v1/templates/{template_id} | Templates Update


## Documentation For Models

 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [LandingGet](docs/LandingGet.md)
 - [LandingHistoryGet](docs/LandingHistoryGet.md)
 - [LandingHistoryListGet](docs/LandingHistoryListGet.md)
 - [LandingListGet](docs/LandingListGet.md)
 - [LandingNew](docs/LandingNew.md)
 - [LandingPatch](docs/LandingPatch.md)
 - [LandingUpdate](docs/LandingUpdate.md)
 - [ResponseWrapper](docs/ResponseWrapper.md)
 - [ResponseWrapperBool](docs/ResponseWrapperBool.md)
 - [ResponseWrapperInt](docs/ResponseWrapperInt.md)
 - [ResponseWrapperLandingGet](docs/ResponseWrapperLandingGet.md)
 - [ResponseWrapperLandingHistoryGet](docs/ResponseWrapperLandingHistoryGet.md)
 - [ResponseWrapperListLandingHistoryListGet](docs/ResponseWrapperListLandingHistoryListGet.md)
 - [ResponseWrapperListLandingListGet](docs/ResponseWrapperListLandingListGet.md)
 - [ResponseWrapperListTemplateListGet](docs/ResponseWrapperListTemplateListGet.md)
 - [ResponseWrapperTemplateGet](docs/ResponseWrapperTemplateGet.md)
 - [Result](docs/Result.md)
 - [TemplateGet](docs/TemplateGet.md)
 - [TemplateListGet](docs/TemplateListGet.md)
 - [TemplateNew](docs/TemplateNew.md)
 - [TemplatePatch](docs/TemplatePatch.md)
 - [TemplateUpdate](docs/TemplateUpdate.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




