#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
from typing import Any

from .recursive import do_recursive


class AsyncOnStop:
    async def _on_stop(self) -> None:
        pass

    @staticmethod
    async def stop_if_necessary(target: Any) -> None:
        await do_recursive(target, lambda x: x._on_stop(), lambda x: isinstance(x, AsyncOnStop))
