# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class FolderCreate(BaseModel):
    """
    FolderCreate
    """
    name: StrictStr = Field(default=..., description="Folder name, e.g. 'images', 'documents'")
    parent_folder_id: Optional[StrictInt] = Field(default=None, description="Parent folder ID, can be used to organize folders in a hierarchy. If null, the folder is in the root.")
    __properties = ["name", "parent_folder_id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FolderCreate:
        """Create an instance of FolderCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FolderCreate:
        """Create an instance of FolderCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FolderCreate.parse_obj(obj)

        _obj = FolderCreate.parse_obj({
            "name": obj.get("name"),
            "parent_folder_id": obj.get("parent_folder_id")
        })
        return _obj


