# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class File(BaseModel):
    """
    File
    """
    name: StrictStr = Field(default=..., description="File name, e.g. 'image.jpg'. This is not the MIME type, but the file name with extension.")
    parent_folder_id: Optional[StrictInt] = Field(default=None, description="Parent folder ID, can be used to organize files in folders. If null, the file is in the root folder.")
    id: StrictInt = Field(default=..., description="Mediastorage database ID, can be used to retrieve the file metadata, delete the file, etc.")
    file_id: StrictStr = Field(default=..., description="Unique file hash identifier that can be used to retrieve the file later")
    extension: StrictStr = Field(default=..., description="File extension, e.g. 'jpg', 'png', 'pdf'. This is not the MIME type, but the file extension.")
    size: StrictInt = Field(default=..., description="File size in bytes. This is the size of the file on disk in bytes.")
    created_at: StrictInt = Field(default=..., description="File creation date in epoch milliseconds. This is the time when the file was uploaded to the server.")
    __properties = ["name", "parent_folder_id", "id", "file_id", "extension", "size", "created_at"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> File:
        """Create an instance of File from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> File:
        """Create an instance of File from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return File.parse_obj(obj)

        _obj = File.parse_obj({
            "name": obj.get("name"),
            "parent_folder_id": obj.get("parent_folder_id"),
            "id": obj.get("id"),
            "file_id": obj.get("file_id"),
            "extension": obj.get("extension"),
            "size": obj.get("size"),
            "created_at": obj.get("created_at")
        })
        return _obj


