# chat-server-connector
Mentortools service for chatting

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.1.0+2022267921
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import chat_server_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import chat_server_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import chat_server_connector
from chat_server_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = chat_server_connector.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: APIKeyHeader
configuration.api_key['APIKeyHeader'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['APIKeyHeader'] = 'Bearer'

# Configure Bearer authorization: HTTPBearer
configuration = chat_server_connector.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
async with chat_server_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = chat_server_connector.DefaultApi(api_client)
    chat_id = 56 # int | 
    chat_member_create = chat_server_connector.ChatMemberCreate() # ChatMemberCreate | 

    try:
        # Chat Members Add
        api_response = await api_instance.chat_members_add_v1_chats_chat_id_members_post(chat_id, chat_member_create)
        print("The response of DefaultApi->chat_members_add_v1_chats_chat_id_members_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->chat_members_add_v1_chats_chat_id_members_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**chat_members_add_v1_chats_chat_id_members_post**](docs/DefaultApi.md#chat_members_add_v1_chats_chat_id_members_post) | **POST** /v1/chats/{chat_id}/members | Chat Members Add
*DefaultApi* | [**chat_members_remove_v1_chats_chat_id_members_delete**](docs/DefaultApi.md#chat_members_remove_v1_chats_chat_id_members_delete) | **DELETE** /v1/chats/{chat_id}/members | Chat Members Remove
*DefaultApi* | [**chat_messages_add_v1_chats_chat_id_messages_post**](docs/DefaultApi.md#chat_messages_add_v1_chats_chat_id_messages_post) | **POST** /v1/chats/{chat_id}/messages | Chat Messages Add
*DefaultApi* | [**chat_messages_get_v1_chats_chat_id_messages_message_id_get**](docs/DefaultApi.md#chat_messages_get_v1_chats_chat_id_messages_message_id_get) | **GET** /v1/chats/{chat_id}/messages/{message_id} | Chat Messages Get
*DefaultApi* | [**chat_messages_list_v1_chats_chat_id_messages_get**](docs/DefaultApi.md#chat_messages_list_v1_chats_chat_id_messages_get) | **GET** /v1/chats/{chat_id}/messages | Chat Messages List
*DefaultApi* | [**chats_add_v1_chats_post**](docs/DefaultApi.md#chats_add_v1_chats_post) | **POST** /v1/chats/ | Chats Add
*DefaultApi* | [**chats_get_v1_chats_chat_id_get**](docs/DefaultApi.md#chats_get_v1_chats_chat_id_get) | **GET** /v1/chats/{chat_id} | Chats Get
*DefaultApi* | [**chats_list_v1_chats_get**](docs/DefaultApi.md#chats_list_v1_chats_get) | **GET** /v1/chats/ | Chats List
*DefaultApi* | [**health_check_get**](docs/DefaultApi.md#health_check_get) | **GET** / | Health Check


## Documentation For Models

 - [ChatGet](docs/ChatGet.md)
 - [ChatGetWithMessages](docs/ChatGetWithMessages.md)
 - [ChatMemberCreate](docs/ChatMemberCreate.md)
 - [ChatMemberGet](docs/ChatMemberGet.md)
 - [ChatMemberRole](docs/ChatMemberRole.md)
 - [ChatMemberRoleAdd](docs/ChatMemberRoleAdd.md)
 - [ChatMessage](docs/ChatMessage.md)
 - [ChatMessageCreate](docs/ChatMessageCreate.md)
 - [ChatMessageRead](docs/ChatMessageRead.md)
 - [ChatNew](docs/ChatNew.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [ResponseWrapper](docs/ResponseWrapper.md)
 - [ResponseWrapperBool](docs/ResponseWrapperBool.md)
 - [ResponseWrapperChatGetWithMessages](docs/ResponseWrapperChatGetWithMessages.md)
 - [ResponseWrapperInt](docs/ResponseWrapperInt.md)
 - [ResponseWrapperListChatGet](docs/ResponseWrapperListChatGet.md)
 - [ResponseWrapperListChatMessageRead](docs/ResponseWrapperListChatMessageRead.md)
 - [Result](docs/Result.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication

<a id="APIKeyHeader"></a>
### APIKeyHeader

- **Type**: API key
- **API key parameter name**: server_name
- **Location**: HTTP header


## Author




