#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass, field


@dataclass
class ComparisonBuffer:
    values: list['ComparisonBuffer | ComparisonLine'] = field(default_factory=list)

    def to_str(self, depth: int = -2) -> str:
        return '\n'.join([value.to_str(depth + 2) for value in self.values])

    def print(self, depth: int = 0) -> None:
        print(self.to_str(depth))

    @property
    def exception(self) -> Exception | None:
        exceptions = []
        for val in self.values:
            if (exc := val.exception) is not None:
                exceptions.append(exc)
        if exceptions:
            return ExceptionGroup('', exceptions)

    def append(self, value: 'ComparisonBuffer | Comparison | Exception') -> None:
        self.values.append(value)
