import logging
from dataclasses import dataclass

import aiohttp
from aiohttp import web
from http_tools.request import IncomingRequest, request_from_web_request

logger = logging.getLogger(__file__)


@dataclass
class WebSocketWrapper:
    incoming_request: IncomingRequest
    web_socket: web.WebSocketResponse


async def ws_from_web_request(web_request: aiohttp.web.Request) -> WebSocketWrapper:
    pure_ws = web.WebSocketResponse()
    await pure_ws.prepare(web_request)
    request = await request_from_web_request(web_request)
    return WebSocketWrapper(incoming_request=request, web_socket=pure_ws)
