#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
import abc
from abc import ABC
from dataclasses import dataclass
from typing import Any, Type


@dataclass
class Expression:
    pass


class AbstractFactory(ABC):
    @abc.abstractmethod
    def __getattr__(self, key: Any):
        pass


class Factory(AbstractFactory):
    def __init__(self, _factory_type: Type[Any]):
        self._function_type: Type[Any] = _factory_type

    def __getattr__(self, key: Any):
        if not isinstance(key, str):
            raise ValueError(f"Cannot create column from non string key: {key}")
        return self._function_type(key)
