#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
import logging
import os
import random

import time

logger = logging.getLogger(__file__)


def exception_to_description(exception: Exception) -> str:
    result = type(exception).__name__
    if str(exception):
        result += f": {exception}"
    return result


def init_random() -> float:
    seed = os.getpid() + time.time()
    random.seed(seed)
    return seed
