# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field
from public_api_server_connector.models.api_key_get import ApiKeyGet
from public_api_server_connector.models.portal_info import PortalInfo
from public_api_server_connector.models.portal_member_base import PortalMemberBase

class TokenInfo(BaseModel):
    """
    TokenInfo
    """
    api_key: ApiKeyGet = Field(...)
    portal: PortalInfo = Field(...)
    owner: PortalMemberBase = Field(...)
    __properties = ["api_key", "portal", "owner"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TokenInfo:
        """Create an instance of TokenInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of api_key
        if self.api_key:
            _dict['api_key'] = self.api_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of portal
        if self.portal:
            _dict['portal'] = self.portal.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TokenInfo:
        """Create an instance of TokenInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TokenInfo.parse_obj(obj)

        _obj = TokenInfo.parse_obj({
            "api_key": ApiKeyGet.from_dict(obj.get("api_key")) if obj.get("api_key") is not None else None,
            "portal": PortalInfo.from_dict(obj.get("portal")) if obj.get("portal") is not None else None,
            "owner": PortalMemberBase.from_dict(obj.get("owner")) if obj.get("owner") is not None else None
        })
        return _obj


