# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from public_api_server_connector.models.lesson_type_str_enum import LessonTypeStrEnum

class ModuleLessonSimple(BaseModel):
    """
    ModuleLessonSimple
    """
    submodule_id: Optional[StrictInt] = Field(default=None, description="ID of the submodule this lesson belongs to, if not part of submodule, it is null, defaults to null")
    thread_id: Optional[StrictInt] = Field(default=None, description="ID of the community thread this lesson belongs to, if not part of thread, it is null, defaults to null")
    lesson_type: LessonTypeStrEnum = Field(default=..., description="Type of the lesson")
    image_id: Optional[StrictStr] = Field(default=None, description="ID of the image associated with the lesson")
    title: StrictStr = Field(default=..., description="Title of the lesson")
    payload: Optional[StrictStr] = Field(default='', description="Payload of the lesson, e.g. description or summary")
    is_active: StrictBool = Field(default=..., description="Whether the lesson is active or not")
    is_published: StrictBool = Field(default=..., description="Whether the lesson is published or not")
    mandatory: StrictBool = Field(default=..., description="Whether the lesson is mandatory to complete the module or not")
    id: StrictInt = Field(default=..., description="ID of the lesson")
    module_id: StrictInt = Field(default=..., description="ID of the module this lesson belongs to")
    order: StrictInt = Field(default=..., description="Order of the lesson in the module")
    __properties = ["submodule_id", "thread_id", "lesson_type", "image_id", "title", "payload", "is_active", "is_published", "mandatory", "id", "module_id", "order"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ModuleLessonSimple:
        """Create an instance of ModuleLessonSimple from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ModuleLessonSimple:
        """Create an instance of ModuleLessonSimple from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ModuleLessonSimple.parse_obj(obj)

        _obj = ModuleLessonSimple.parse_obj({
            "submodule_id": obj.get("submodule_id"),
            "thread_id": obj.get("thread_id"),
            "lesson_type": obj.get("lesson_type"),
            "image_id": obj.get("image_id"),
            "title": obj.get("title"),
            "payload": obj.get("payload") if obj.get("payload") is not None else '',
            "is_active": obj.get("is_active"),
            "is_published": obj.get("is_published"),
            "mandatory": obj.get("mandatory"),
            "id": obj.get("id"),
            "module_id": obj.get("module_id"),
            "order": obj.get("order")
        })
        return _obj


