#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mikhail Mamrov <m.mamrov@abm-jsc.ru>
#
from dataclasses import dataclass

from detector_connector import DetectorSettings


@dataclass(frozen=True)
class ImageBox:
    id: int
    rtsp_url: str
    left_up_x_percentage: float
    left_up_y_percentage: float
    right_bottom_x_percentage: float
    right_bottom_y_percentage: float
    created_at: float | None = None


@dataclass(kw_only=True, frozen=True)
class PollutionSetting(DetectorSettings):
    ignored_image_boxes: list[ImageBox]
