#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
from dataclasses import dataclass, field
from typing import Optional, Dict, Any

from yarl import URL


@dataclass
class RequestMetadata:
    http_request_host: Optional[str] = None
    request_method: Optional[str] = None
    path_info: Optional[str] = None
    url: Optional[URL] = None
    header_name_to_value: Dict[str, Any] = field(default_factory=dict)

    def get_header(self, header_name: str, case_insensitive: bool = True, default: Any = None):
        if case_insensitive:
            name = header_name.lower()
            for key, value in self.header_name_to_value.items():
                if key.lower() == name:
                    return value

            return default
        else:
            return self.header_name_to_value.get(header_name, default)
