#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import sqlalchemy as sa
from alembic import op


def update_table_data(table_name: str, column_to_expression: dict[sa.Column, sa.ColumnElement]) -> None:
    ephemeral_table = sa.table(table_name, *column_to_expression)
    stmt = sa.update(ephemeral_table)
    stmt = stmt.values(**{
        column.name: expression for column, expression in column_to_expression.items() if expression is not None
    })
    op.execute(stmt)
