#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import enum


class When(enum.StrEnum):
    BEFORE = 'BEFORE'
    AFTER = 'AFTER'
    INSTEAD_OF = 'INSTEAD OF'


class Operation(enum.StrEnum):
    INSERT = 'INSERT'
    UPDATE = 'UPDATE'
    DELETE = 'DELETE'
    TRUNCATE = 'TRUNCATE'


def get_trigger_name(table_name: str, when: When, operation: Operation, revision: str) -> str:
    return f'{when.lower()}_{operation.lower()}_{table_name}_trigger_{revision}'


def get_function_name(table_name: str, when: When, operation: Operation, revision: str) -> str:
    return f'{when.lower()}_{operation.lower()}_{table_name}_func_{revision}'
