from enum import unique, Enum


@unique
class ContentType(str, Enum):
    Atom = 'application/atom+xml'
    EDI_X12 = 'application/EDI-X12'
    EDIFACT = 'application/EDIFACT'
    Json = 'application/json'
    ProblemJson = 'application/problem+json'
    JavaScript = 'application/javascript'
    Octet = 'application/octet-stream'
    Ogg = 'application/ogg'
    PDF = 'application/pdf'
    PostScript = 'application/postscript'
    SOAP = 'application/soap+xml'
    Web = 'application/font-woff'
    XHTML = 'application/xhtml+xml'
    DTD = 'application/xml-dtd'
    XOP = 'application/xop+xml'
    ZIP = 'application/zip'
    Gzip = 'application/gzip'
    BitTorrent = 'application/x-bittorrent'
    TeX = 'application/x-tex '
    XML = 'application/xml'
    DOC = 'application/msword'
    FormUrlEncoded = 'application/x-www-form-urlencoded'
    DVI = 'application/x-dvi'
    LaTeX = 'application/x-latex'
    TTF = 'application/x-font-ttf'
    AdobeFlash = 'application/x-shockwave-flash'
    StuffIt = 'application/x-stuffit'
    RAR = 'application/x-rar-compressed'
    Tarball = 'application/x-tar'
    XJavascript = 'application/x-javascript'
    MicrosoftExcel = 'application/vnd.ms-excel'
    MicrosoftPowerpoint = 'application/vnd.ms-powerpoint'
    XLSX = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
    Mozilla = 'application/vnd.mozilla.xul+xml'

    Mulaw = 'audio/basic'
    PCM24bit = 'audio/L24'
    Mp4Audio = 'audio/mp4'
    AAC = 'audio/aac'
    MP3 = 'audio/mpeg'
    OggVorbis = 'audio/ogg'
    Vorbis = 'audio/vorbis'
    WindowsAudio = 'audio/x-ms-wma'
    WindowsMedia = 'audio/x-ms-wax'
    RealAudio = 'audio/vnd.rn-realaudio'
    WAV = 'audio/vnd.wave'
    WebMAudio = 'audio/webm'

    GIF = 'image/gif'
    JPEG = 'image/jpeg'
    PJPEG = 'image/pjpeg'
    PNG = 'image/png'
    SVG = 'image/svg+xml'
    TIFF = 'image/tiff'
    ICO = 'image/vnd.microsoft.icon'
    WBMP = 'image/vnd.wap.wbmp'
    WebP = 'image/webp'
    RGB = 'image/x-rgb'
    BMP = 'image/bmp'
    MS_BMP = 'image/x-ms-bmp'
    WINDOWS_BMP = 'image/x-windows-bmp'

    HTTP = 'message/http'
    IMDN = 'message/imdn+xml'
    EmailPartial = 'message/partial'
    Email = 'message/rfc822'

    ModelExample = 'model/example'
    IGS = 'model/iges'
    MSH = 'model/mesh'
    WRL = 'model/vrml'
    X3DB = 'model/x3d+binary'
    X3DV_VRML = 'model/x3d+vrml'
    X3D_XML = 'model/x3d+xml'

    MultipartMixed = 'multipart/mixed'
    MultipartAlternative = 'multipart/alternative'
    MultipartRelated = 'multipart/related'
    MultipartForm = 'multipart/form-data'
    MultipartSigned = 'multipart/signed'
    MultipartEncrypted = 'multipart/encrypted'

    CMD = 'text/cmd'
    Css = 'text/css'
    CSV = 'text/csv'
    HTML = 'text/html'
    Text = 'text/plain'
    PHP = 'text/php'
    XmlText = 'text/xml'
    Markdown = 'text/markdown'
    Cache = 'text/cache-manifest'
    jQuery = 'text/x-jquery-tmpl'
    TSV = 'text/tab-separated-values'

    MPEG = 'video/mpeg'
    MKV = 'video/x-matroska'
    Mp4Video = 'video/mp4'
    OggVideo = 'video/ogg'
    QuickTime = 'video/quicktime'
    WebMVideo = 'video/webm'
    WindowsVideo = 'video/x-ms-wmv'
    FLV = 'video/x-flv'
    gpp = 'video/3gpp'
    gpp2 = 'video/3gpp2'
    TS = 'video/mp2t'
    M3U8 = 'video/x-mpegURL'
    AVI = 'video/x-msvideo'
