#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>


import logging
from dataclasses import dataclass
from typing import Optional
from http_tools.http_server_connector import HttpServerConnector


logger = logging.getLogger(__name__)


class SnapshotConnector:

    @dataclass
    class SnapshotConnectorConfig:
        server_name: str

    @dataclass
    class Config(HttpServerConnector.Config, SnapshotConnectorConfig):
        pass

    Context = HttpServerConnector.Context

    def __init__(self, config: Config, context: Context):
        self._config = config
        self._context = context
        self._connector = HttpServerConnector(config, context)

    async def get_snapshot(self, stream_url: str, snapshot_timeout_s: Optional[int] = None) -> bytes:
        args = {"stream_url": stream_url}
        if snapshot_timeout_s is not None:
            args["snapshot_timeout_s"] = snapshot_timeout_s

        return await self._connector.get("/snapshot/get", args, headers=self._get_auth_header())

    def _get_auth_header(self) -> dict[str, str]:
        return {"server_name": self._config.server_name}
