# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['snapshoter_connector']

package_data = \
{'': ['*']}

install_requires = \
['http-tools-abm>=1.0.47474,<2.0.0']

setup_kwargs = {
    'name': 'snapshoter-connector-abm',
    'version': '0.1.0',
    'description': 'connector to snapshoter',
    'long_description': '## EmailServiceV2Connector\n\nClient for sending emails via EmailServiceV2\n\n## Library Installation\n\n```\npip install --extra-index-url https://pypi.abm-jsc.ru snapshoter-connector-abm\n```\n\n## Quick Start\n\n\n#### Getting snapshot\n```python\nimport asyncio\n\nimport aiohttp\nfrom snapshoter_connector.connector import SnapshotConnector\n\n\nasync def make_snapshot():\n    \n    session = aiohttp.ClientSession()\n\n    email_service_connector = SnapshotConnector(\n        config=SnapshotConnector.Config(\n            url=\'127.0.0.1:8080\',\n            server_name=\'immovable_server\',\n        ),\n        context=SnapshotConnector.Context(\n            session=session,\n        ),\n    )\n    rstp_url = "rtsp://login:pass@ip"\n    snapshot = await email_service_connector.get_snapshot(rstp_url)\n    print(len(snapshot))\n    await session.close()\n\n\nasyncio.run(make_snapshot())\n```\n',
    'author': 'i.vasiliev',
    'author_email': 'i.vasiliev@technokert.ru',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
