# coding: utf-8

"""
    Fal.ai Video Connector

    FastAPI connector for fal.ai video generation using Wan 2.6 model

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, constr
from fal_ai_connector.models.video_duration import VideoDuration
from fal_ai_connector.models.video_preset import VideoPreset

class TextToVideoApiRequest(BaseModel):
    """
    TextToVideoApiRequest
    """
    prompt: constr(strict=True, max_length=800) = Field(...)
    preset: Optional[VideoPreset] = None
    duration: Optional[VideoDuration] = None
    __properties = ["prompt", "preset", "duration"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TextToVideoApiRequest:
        """Create an instance of TextToVideoApiRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TextToVideoApiRequest:
        """Create an instance of TextToVideoApiRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TextToVideoApiRequest.parse_obj(obj)

        _obj = TextToVideoApiRequest.parse_obj({
            "prompt": obj.get("prompt"),
            "preset": obj.get("preset"),
            "duration": obj.get("duration")
        })
        return _obj


