# coding: utf-8

"""
    Fal.ai Video Connector

    FastAPI connector for fal.ai video generation using Wan 2.6 model

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from fal_ai_connector.models.image_to_video_api_request import ImageToVideoApiRequest
from fal_ai_connector.models.text_to_video_api_request import TextToVideoApiRequest
from fal_ai_connector.models.wrapped_response_video_api_response import WrappedResponseVideoApiResponse

from fal_ai_connector.api_client import ApiClient
from fal_ai_connector.api_response import ApiResponse
from fal_ai_connector.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class VideoGenerationApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    async def generate_video_from_image_video_v1_image_to_video_post(self, image_to_video_api_request : ImageToVideoApiRequest, **kwargs) -> WrappedResponseVideoApiResponse:  # noqa: E501
        """Generate video from image  # noqa: E501

        Generate a video from an image.  # noqa: E501

        :param image_to_video_api_request: (required)
        :type image_to_video_api_request: ImageToVideoApiRequest
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseVideoApiResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the generate_video_from_image_video_v1_image_to_video_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.generate_video_from_image_video_v1_image_to_video_post_with_http_info(image_to_video_api_request, **kwargs)  # noqa: E501

    @validate_arguments
    async def generate_video_from_image_video_v1_image_to_video_post_with_http_info(self, image_to_video_api_request : ImageToVideoApiRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """Generate video from image  # noqa: E501

        Generate a video from an image.  # noqa: E501

        :param image_to_video_api_request: (required)
        :type image_to_video_api_request: ImageToVideoApiRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseVideoApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'image_to_video_api_request'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_video_from_image_video_v1_image_to_video_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['image_to_video_api_request'] is not None:
            _body_params = _params['image_to_video_api_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseVideoApiResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/video/v1/image_to_video', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def generate_video_from_text_video_v1_text_to_video_post(self, text_to_video_api_request : TextToVideoApiRequest, **kwargs) -> WrappedResponseVideoApiResponse:  # noqa: E501
        """Generate video from text  # noqa: E501

        Generate a video from a text prompt.  # noqa: E501

        :param text_to_video_api_request: (required)
        :type text_to_video_api_request: TextToVideoApiRequest
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseVideoApiResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the generate_video_from_text_video_v1_text_to_video_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.generate_video_from_text_video_v1_text_to_video_post_with_http_info(text_to_video_api_request, **kwargs)  # noqa: E501

    @validate_arguments
    async def generate_video_from_text_video_v1_text_to_video_post_with_http_info(self, text_to_video_api_request : TextToVideoApiRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """Generate video from text  # noqa: E501

        Generate a video from a text prompt.  # noqa: E501

        :param text_to_video_api_request: (required)
        :type text_to_video_api_request: TextToVideoApiRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseVideoApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'text_to_video_api_request'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_video_from_text_video_v1_text_to_video_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['text_to_video_api_request'] is not None:
            _body_params = _params['text_to_video_api_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseVideoApiResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/video/v1/text_to_video', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
