# coding: utf-8

"""
    Mentortools RAG service

    API for indexing lessons information into a vector database

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conint, conlist

class SearchRequestBody(BaseModel):
    """
    SearchRequestBody
    """
    query: StrictStr = Field(default=..., description="The search query text")
    sources: Optional[conlist(StrictStr)] = None
    access_tokens: Optional[conlist(StrictStr)] = None
    top_k: Optional[conint(strict=True, le=20, ge=1)] = Field(default=5, description="Number of top results to return")
    __properties = ["query", "sources", "access_tokens", "top_k"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SearchRequestBody:
        """Create an instance of SearchRequestBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if sources (nullable) is None
        # and __fields_set__ contains the field
        if self.sources is None and "sources" in self.__fields_set__:
            _dict['sources'] = None

        # set to None if access_tokens (nullable) is None
        # and __fields_set__ contains the field
        if self.access_tokens is None and "access_tokens" in self.__fields_set__:
            _dict['access_tokens'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SearchRequestBody:
        """Create an instance of SearchRequestBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SearchRequestBody.parse_obj(obj)

        _obj = SearchRequestBody.parse_obj({
            "query": obj.get("query"),
            "sources": obj.get("sources"),
            "access_tokens": obj.get("access_tokens"),
            "top_k": obj.get("top_k") if obj.get("top_k") is not None else 5
        })
        return _obj


