# coding: utf-8

"""
    Mentortools RAG service

    API for indexing lessons information into a vector database

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr, conlist

from typing import Any, Dict, List, Optional

from rag_server_connector.models.batch_delete_data import BatchDeleteData
from rag_server_connector.models.batch_index_data import BatchIndexData
from rag_server_connector.models.index_data import IndexData
from rag_server_connector.models.search_request_body import SearchRequestBody
from rag_server_connector.models.search_result import SearchResult

from rag_server_connector.api_client import ApiClient
from rag_server_connector.api_response import ApiResponse
from rag_server_connector.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DefaultApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    async def batch_delete_sources_sources_batch_index_delete(self, batch_delete_data : BatchDeleteData, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Batch Delete Sources  # noqa: E501

        Delete chunks for multiple sources in a single batch operation.  Requires API key authentication via X-API-Key header.  Args:     data: A validated BatchDeleteData model containing a list of source identifiers     api_key: API key from X-API-Key header (validated by dependency)  Returns:     Dict: A dictionary with overall statistics and detailed results for each source  # noqa: E501

        :param batch_delete_data: (required)
        :type batch_delete_data: BatchDeleteData
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the batch_delete_sources_sources_batch_index_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.batch_delete_sources_sources_batch_index_delete_with_http_info(batch_delete_data, **kwargs)  # noqa: E501

    @validate_arguments
    async def batch_delete_sources_sources_batch_index_delete_with_http_info(self, batch_delete_data : BatchDeleteData, **kwargs) -> ApiResponse:  # noqa: E501
        """Batch Delete Sources  # noqa: E501

        Delete chunks for multiple sources in a single batch operation.  Requires API key authentication via X-API-Key header.  Args:     data: A validated BatchDeleteData model containing a list of source identifiers     api_key: API key from X-API-Key header (validated by dependency)  Returns:     Dict: A dictionary with overall statistics and detailed results for each source  # noqa: E501

        :param batch_delete_data: (required)
        :type batch_delete_data: BatchDeleteData
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'batch_delete_data'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_delete_sources_sources_batch_index_delete" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['batch_delete_data'] is not None:
            _body_params = _params['batch_delete_data']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/sources/batch/index', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def batch_index_sources_sources_batch_index_put(self, batch_index_data : BatchIndexData, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Batch Index Sources  # noqa: E501

        Create or update multiple sources in a single batch operation.  Requires API key authentication via X-API-Key header.  Args:     data: A validated BatchIndexData model containing a list of sources     api_key: API key from X-API-Key header (validated by dependency)  Returns:     Dict: A dictionary with overall statistics and detailed results for each source  # noqa: E501

        :param batch_index_data: (required)
        :type batch_index_data: BatchIndexData
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the batch_index_sources_sources_batch_index_put_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.batch_index_sources_sources_batch_index_put_with_http_info(batch_index_data, **kwargs)  # noqa: E501

    @validate_arguments
    async def batch_index_sources_sources_batch_index_put_with_http_info(self, batch_index_data : BatchIndexData, **kwargs) -> ApiResponse:  # noqa: E501
        """Batch Index Sources  # noqa: E501

        Create or update multiple sources in a single batch operation.  Requires API key authentication via X-API-Key header.  Args:     data: A validated BatchIndexData model containing a list of sources     api_key: API key from X-API-Key header (validated by dependency)  Returns:     Dict: A dictionary with overall statistics and detailed results for each source  # noqa: E501

        :param batch_index_data: (required)
        :type batch_index_data: BatchIndexData
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'batch_index_data'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_index_sources_sources_batch_index_put" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['batch_index_data'] is not None:
            _body_params = _params['batch_index_data']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/sources/batch/index', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def delete_source_index_sources_index_delete(self, source : Annotated[StrictStr, Field(..., description="Source identifier to delete (e.g., 'lesson_12', 'course_1583')")], **kwargs) -> Dict[str, object]:  # noqa: E501
        """Delete Source Index  # noqa: E501

        Delete all chunks associated with a source.  Requires API key authentication via X-API-Key header.  Args:     source: The source identifier to delete     api_key: API key from X-API-Key header (validated by dependency)  Returns:     Dict: A dictionary indicating success status, message, and deleted count  # noqa: E501

        :param source: Source identifier to delete (e.g., 'lesson_12', 'course_1583') (required)
        :type source: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_source_index_sources_index_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.delete_source_index_sources_index_delete_with_http_info(source, **kwargs)  # noqa: E501

    @validate_arguments
    async def delete_source_index_sources_index_delete_with_http_info(self, source : Annotated[StrictStr, Field(..., description="Source identifier to delete (e.g., 'lesson_12', 'course_1583')")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete Source Index  # noqa: E501

        Delete all chunks associated with a source.  Requires API key authentication via X-API-Key header.  Args:     source: The source identifier to delete     api_key: API key from X-API-Key header (validated by dependency)  Returns:     Dict: A dictionary indicating success status, message, and deleted count  # noqa: E501

        :param source: Source identifier to delete (e.g., 'lesson_12', 'course_1583') (required)
        :type source: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'source'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_source_index_sources_index_delete" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('source') is not None:  # noqa: E501
            _query_params.append(('source', _params['source']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/sources/index', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def health_check_health_get(self, **kwargs) -> object:  # noqa: E501
        """Health Check  # noqa: E501

        Health check endpoint to verify the API is running  # noqa: E501

        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the health_check_health_get_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.health_check_health_get_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    async def health_check_health_get_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Health Check  # noqa: E501

        Health check endpoint to verify the API is running  # noqa: E501

        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method health_check_health_get" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "object",
        }

        return await self.api_client.call_api(
            '/health', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def index_source_sources_index_put(self, index_data : IndexData, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Index Source  # noqa: E501

        Create or update a source (lesson, course, module, etc.) by deleting old chunks (if any) and creating new ones.  Requires API key authentication via X-API-Key header.  Args:     data: A validated IndexData model containing source and text data     api_key: API key from X-API-Key header (validated by dependency)  Returns:     Dict: A dictionary indicating success status, message, and chunk counts  # noqa: E501

        :param index_data: (required)
        :type index_data: IndexData
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the index_source_sources_index_put_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.index_source_sources_index_put_with_http_info(index_data, **kwargs)  # noqa: E501

    @validate_arguments
    async def index_source_sources_index_put_with_http_info(self, index_data : IndexData, **kwargs) -> ApiResponse:  # noqa: E501
        """Index Source  # noqa: E501

        Create or update a source (lesson, course, module, etc.) by deleting old chunks (if any) and creating new ones.  Requires API key authentication via X-API-Key header.  Args:     data: A validated IndexData model containing source and text data     api_key: API key from X-API-Key header (validated by dependency)  Returns:     Dict: A dictionary indicating success status, message, and chunk counts  # noqa: E501

        :param index_data: (required)
        :type index_data: IndexData
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'index_data'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_source_sources_index_put" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['index_data'] is not None:
            _body_params = _params['index_data']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/sources/index', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def search_sources_get_sources_search_get(self, query : StrictStr, sources : Annotated[Optional[conlist(StrictStr)], Field(description="List of source identifiers to filter by (e.g., 'lesson_12', 'course_1583')")] = None, access_tokens : Annotated[Optional[conlist(StrictStr)], Field(description="List of access tokens to filter results (chunks must have overlapping tokens)")] = None, top_k : Annotated[Optional[StrictInt], Field(description="Number of top results to return")] = None, **kwargs) -> List[SearchResult]:  # noqa: E501
        """Search Sources Get  # noqa: E501

        Search for relevant chunks based on the query (GET method).  Requires API key authentication via X-API-Key header.  Note: For queries with many access tokens (100+), use POST /sources/search instead to avoid URL length limits.  Args:     query: The search query text     sources: List of source identifiers to filter the search (optional)     access_tokens: List of access tokens - only chunks with overlapping tokens will be returned (optional)     top_k: Number of top results to return (default: 5)     api_key: API key from X-API-Key header (validated by dependency)  Note:     At least one of 'sources' or 'access_tokens' must be provided.  Returns:     List[SearchResult]: A list of search results with text and metadata  # noqa: E501

        :param query: (required)
        :type query: str
        :param sources: List of source identifiers to filter by (e.g., 'lesson_12', 'course_1583')
        :type sources: List[str]
        :param access_tokens: List of access tokens to filter results (chunks must have overlapping tokens)
        :type access_tokens: List[str]
        :param top_k: Number of top results to return
        :type top_k: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[SearchResult]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the search_sources_get_sources_search_get_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.search_sources_get_sources_search_get_with_http_info(query, sources, access_tokens, top_k, **kwargs)  # noqa: E501

    @validate_arguments
    async def search_sources_get_sources_search_get_with_http_info(self, query : StrictStr, sources : Annotated[Optional[conlist(StrictStr)], Field(description="List of source identifiers to filter by (e.g., 'lesson_12', 'course_1583')")] = None, access_tokens : Annotated[Optional[conlist(StrictStr)], Field(description="List of access tokens to filter results (chunks must have overlapping tokens)")] = None, top_k : Annotated[Optional[StrictInt], Field(description="Number of top results to return")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Search Sources Get  # noqa: E501

        Search for relevant chunks based on the query (GET method).  Requires API key authentication via X-API-Key header.  Note: For queries with many access tokens (100+), use POST /sources/search instead to avoid URL length limits.  Args:     query: The search query text     sources: List of source identifiers to filter the search (optional)     access_tokens: List of access tokens - only chunks with overlapping tokens will be returned (optional)     top_k: Number of top results to return (default: 5)     api_key: API key from X-API-Key header (validated by dependency)  Note:     At least one of 'sources' or 'access_tokens' must be provided.  Returns:     List[SearchResult]: A list of search results with text and metadata  # noqa: E501

        :param query: (required)
        :type query: str
        :param sources: List of source identifiers to filter by (e.g., 'lesson_12', 'course_1583')
        :type sources: List[str]
        :param access_tokens: List of access tokens to filter results (chunks must have overlapping tokens)
        :type access_tokens: List[str]
        :param top_k: Number of top results to return
        :type top_k: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[SearchResult], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'sources',
            'access_tokens',
            'top_k'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_sources_get_sources_search_get" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query') is not None:  # noqa: E501
            _query_params.append(('query', _params['query']))

        if _params.get('sources') is not None:  # noqa: E501
            _query_params.append(('sources', _params['sources']))
            _collection_formats['sources'] = 'multi'

        if _params.get('access_tokens') is not None:  # noqa: E501
            _query_params.append(('access_tokens', _params['access_tokens']))
            _collection_formats['access_tokens'] = 'multi'

        if _params.get('top_k') is not None:  # noqa: E501
            _query_params.append(('top_k', _params['top_k']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader']  # noqa: E501

        _response_types_map = {
            '200': "List[SearchResult]",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/sources/search', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def search_sources_post_sources_search_post(self, search_request_body : SearchRequestBody, **kwargs) -> List[SearchResult]:  # noqa: E501
        """Search Sources Post  # noqa: E501

        Search for relevant chunks based on the query (POST method).  Requires API key authentication via X-API-Key header.  This endpoint is recommended for queries with many access tokens (100+) as it avoids URL length limits by accepting parameters in the request body.  Args:     request: Search request with query, filters, and parameters     api_key: API key from X-API-Key header (validated by dependency)  Note:     At least one of 'sources' or 'access_tokens' must be provided in the request body.  Returns:     List[SearchResult]: A list of search results with text and metadata  # noqa: E501

        :param search_request_body: (required)
        :type search_request_body: SearchRequestBody
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[SearchResult]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the search_sources_post_sources_search_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.search_sources_post_sources_search_post_with_http_info(search_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    async def search_sources_post_sources_search_post_with_http_info(self, search_request_body : SearchRequestBody, **kwargs) -> ApiResponse:  # noqa: E501
        """Search Sources Post  # noqa: E501

        Search for relevant chunks based on the query (POST method).  Requires API key authentication via X-API-Key header.  This endpoint is recommended for queries with many access tokens (100+) as it avoids URL length limits by accepting parameters in the request body.  Args:     request: Search request with query, filters, and parameters     api_key: API key from X-API-Key header (validated by dependency)  Note:     At least one of 'sources' or 'access_tokens' must be provided in the request body.  Returns:     List[SearchResult]: A list of search results with text and metadata  # noqa: E501

        :param search_request_body: (required)
        :type search_request_body: SearchRequestBody
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[SearchResult], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'search_request_body'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_sources_post_sources_search_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['search_request_body'] is not None:
            _body_params = _params['search_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader']  # noqa: E501

        _response_types_map = {
            '200': "List[SearchResult]",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/sources/search', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
