# Technical Support Connector

Asynchronous client to connect to technical support for asyncio and Python.

## Library Installation
```
pip install --extra-index-url https://pypi.abm-jsc.ru tech-support-connector-abm
```
## Quick Start and basic requests

```python
import asyncio
from aiohttp import ClientSession

from tech_support_connector import TicketType
from tech_support_connector import TechSupportConnector
from tech_support_connector import TechSupportTicketsFacade


async def main():
    session = ClientSession()
    tech_support_connector = TechSupportConnector(
        config=TechSupportConnector.Config(
            username="username", password="password", location="https://*"
        ),
        context=TechSupportConnector.Context(
            session=session,
        )
    )
    tech_support_facade = TechSupportTicketsFacade(
        TechSupportTicketsFacade.Context(
            tech_support_connector=tech_support_connector
        )
    )

    tickets_with_limit = await tech_support_facade.load(fields=["ТекущийЭтап"],
                                                        filters={"Статус": {
                                                            "Тип": "EnumRef.itilprofСтатусыПроцессов",
                                                            "Значение": "Черновик",
                                                            "Наименование": "Новый"}},
                                                        limit=10,
                                                        since="0000-001357503")

    first_ticket = await tech_support_facade.load_one_or_none(fields=["ТекущийЭтап"],
                                                              filters={"Статус": {
                                                                  "Тип": "EnumRef.itilprofСтатусыПроцессов",
                                                                  "Значение": "Черновик",
                                                                  "Наименование": "Новый"}})

    all_tickets = await tech_support_facade.load_all(fields=["ТекущийЭтап"],
                                                     filters={"Статус": {
                                                         "Тип": "EnumRef.itilprofСтатусыПроцессов",
                                                         "Значение": "Черновик",
                                                         "Наименование": "Новый"}})

    ticket_info = await tech_support_facade.info("ticket_uuid", TicketType.MAINTENANCE)

    ticket_stages = await tech_support_facade.load_stages("ticket_uuid", TicketType.MAINTENANCE)

    ticket_update = await tech_support_facade.update("ticket_uuid",
                                                     TicketType.MAINTENANCE,
                                                     {"some_info_to_update": "some_info_to_update"})

    create_update = await tech_support_facade.add({"canal": "ext",
                                                   "name": "Тема обращения",
                                                   "text": "Текст обращения",
                                                   "service_id": "service_id",
                                                   "email": "email",
                                                   "user_name": "ФИО"
                                                   })

    await session.close()


asyncio.run(main())
```