#  Copyright (C) 2024
#  ABM JSC, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Albakov Ruslan <r.albakov@abm-jsc.ru>
from abc import ABC, abstractmethod
from contextlib import asynccontextmanager
from typing import Hashable


class AbstractSemaphore(ABC):
    @asynccontextmanager
    @abstractmethod
    async def restrict(self, key: Hashable, concurrency_limit: int = 1) -> None:
        pass
