#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>
import logging

from aiohttp import hdrs, web

from http_tools.error_middleware import Handler, WsHandler


logger = logging.getLogger(__name__)


@web.middleware
async def compress_middleware(
        request: web.Request, handler: Handler | WsHandler, *args, **kwargs
) -> web.WebSocketResponse | web.Response:
    response = await handler(request)
    accept_encoding = request.headers.get(hdrs.ACCEPT_ENCODING, '').lower()
    content_encoding = next((coding for coding in ('gzip', 'deflate') if coding in accept_encoding), None)
    if content_encoding is not None:
        logger.debug(f'Response body compression enabled: {content_encoding}')
        response.headers[hdrs.CONTENT_ENCODING] = content_encoding
        response.enable_compression()
    return response
