# coding: utf-8

"""
    Mentortools Team Member Server

    Mentortools service for Team Members

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class PortalMemberSchema(BaseModel):
    """
    PortalMemberSchema
    """
    id: StrictInt = Field(...)
    first_name: StrictStr = Field(...)
    last_name: StrictStr = Field(...)
    email: StrictStr = Field(...)
    avatar_id: Optional[StrictStr] = None
    __properties = ["id", "first_name", "last_name", "email", "avatar_id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PortalMemberSchema:
        """Create an instance of PortalMemberSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if avatar_id (nullable) is None
        # and __fields_set__ contains the field
        if self.avatar_id is None and "avatar_id" in self.__fields_set__:
            _dict['avatar_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PortalMemberSchema:
        """Create an instance of PortalMemberSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PortalMemberSchema.parse_obj(obj)

        _obj = PortalMemberSchema.parse_obj({
            "id": obj.get("id"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "email": obj.get("email"),
            "avatar_id": obj.get("avatar_id")
        })
        return _obj


