# coding: utf-8

"""
    Mentortools Team Member Server

    Mentortools service for Team Members

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic import Field, StrictStr

from typing import Optional

from team_member_server_sdk.models.activate_team_member_request import ActivateTeamMemberRequest
from team_member_server_sdk.models.disable_team_member_request import DisableTeamMemberRequest
from team_member_server_sdk.models.enable_team_member_request import EnableTeamMemberRequest
from team_member_server_sdk.models.invite_team_member_request import InviteTeamMemberRequest
from team_member_server_sdk.models.remove_team_member_request import RemoveTeamMemberRequest
from team_member_server_sdk.models.resend_invitation_email_request import ResendInvitationEmailRequest
from team_member_server_sdk.models.team_member_actions_request import TeamMemberActionsRequest
from team_member_server_sdk.models.team_member_amount_request import TeamMemberAmountRequest
from team_member_server_sdk.models.team_member_request import TeamMemberRequest
from team_member_server_sdk.models.update_team_member_request import UpdateTeamMemberRequest
from team_member_server_sdk.models.wrapped_response_int import WrappedResponseInt
from team_member_server_sdk.models.wrapped_response_list_team_member_response import WrappedResponseListTeamMemberResponse
from team_member_server_sdk.models.wrapped_response_team_member_access_response import WrappedResponseTeamMemberAccessResponse
from team_member_server_sdk.models.wrapped_response_team_member_response import WrappedResponseTeamMemberResponse

from team_member_server_sdk.api_client import ApiClient
from team_member_server_sdk.api_response import ApiResponse
from team_member_server_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TeamMemberApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    async def activate_team_member_v1_team_member_activate_post(self, activate_team_member_request : ActivateTeamMemberRequest, **kwargs) -> WrappedResponseTeamMemberResponse:  # noqa: E501
        """Activate Team Member  # noqa: E501

        This endpoint activate Team Member. Allowed only for Server requests  # noqa: E501

        :param activate_team_member_request: (required)
        :type activate_team_member_request: ActivateTeamMemberRequest
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseTeamMemberResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the activate_team_member_v1_team_member_activate_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.activate_team_member_v1_team_member_activate_post_with_http_info(activate_team_member_request, **kwargs)  # noqa: E501

    @validate_arguments
    async def activate_team_member_v1_team_member_activate_post_with_http_info(self, activate_team_member_request : ActivateTeamMemberRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """Activate Team Member  # noqa: E501

        This endpoint activate Team Member. Allowed only for Server requests  # noqa: E501

        :param activate_team_member_request: (required)
        :type activate_team_member_request: ActivateTeamMemberRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseTeamMemberResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'activate_team_member_request'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method activate_team_member_v1_team_member_activate_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['activate_team_member_request'] is not None:
            _body_params = _params['activate_team_member_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ServerName Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseTeamMemberResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/activate', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def disable_team_member_v1_team_member_disable_post(self, disable_team_member_request : DisableTeamMemberRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseTeamMemberResponse:  # noqa: E501
        """Disable Team Member  # noqa: E501

        This endpoint diable Team Member. Allowed only for Admins / Portal Owners.  # noqa: E501

        :param disable_team_member_request: (required)
        :type disable_team_member_request: DisableTeamMemberRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseTeamMemberResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the disable_team_member_v1_team_member_disable_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.disable_team_member_v1_team_member_disable_post_with_http_info(disable_team_member_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def disable_team_member_v1_team_member_disable_post_with_http_info(self, disable_team_member_request : DisableTeamMemberRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Disable Team Member  # noqa: E501

        This endpoint diable Team Member. Allowed only for Admins / Portal Owners.  # noqa: E501

        :param disable_team_member_request: (required)
        :type disable_team_member_request: DisableTeamMemberRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseTeamMemberResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'disable_team_member_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_team_member_v1_team_member_disable_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['disable_team_member_request'] is not None:
            _body_params = _params['disable_team_member_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseTeamMemberResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/disable', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def enable_team_member_v1_team_member_enable_post(self, enable_team_member_request : EnableTeamMemberRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseTeamMemberResponse:  # noqa: E501
        """Enable Team Member  # noqa: E501

        This endpoint enable Team Member. Allowed only for Admins / Portal Owners.  # noqa: E501

        :param enable_team_member_request: (required)
        :type enable_team_member_request: EnableTeamMemberRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseTeamMemberResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the enable_team_member_v1_team_member_enable_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.enable_team_member_v1_team_member_enable_post_with_http_info(enable_team_member_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def enable_team_member_v1_team_member_enable_post_with_http_info(self, enable_team_member_request : EnableTeamMemberRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Enable Team Member  # noqa: E501

        This endpoint enable Team Member. Allowed only for Admins / Portal Owners.  # noqa: E501

        :param enable_team_member_request: (required)
        :type enable_team_member_request: EnableTeamMemberRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseTeamMemberResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'enable_team_member_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_team_member_v1_team_member_enable_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['enable_team_member_request'] is not None:
            _body_params = _params['enable_team_member_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseTeamMemberResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/enable', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def get_team_member_access_v1_team_member_access_get_post(self, team_member_actions_request : TeamMemberActionsRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseTeamMemberAccessResponse:  # noqa: E501
        """Get Team Member access  # noqa: E501

        This endpoint returns Team Member access. Allowed for Team Members (portal_member_id should be None) / server requests (portal_member_id shouldn't be None)  # noqa: E501

        :param team_member_actions_request: (required)
        :type team_member_actions_request: TeamMemberActionsRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseTeamMemberAccessResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_team_member_access_v1_team_member_access_get_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.get_team_member_access_v1_team_member_access_get_post_with_http_info(team_member_actions_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def get_team_member_access_v1_team_member_access_get_post_with_http_info(self, team_member_actions_request : TeamMemberActionsRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Team Member access  # noqa: E501

        This endpoint returns Team Member access. Allowed for Team Members (portal_member_id should be None) / server requests (portal_member_id shouldn't be None)  # noqa: E501

        :param team_member_actions_request: (required)
        :type team_member_actions_request: TeamMemberActionsRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseTeamMemberAccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'team_member_actions_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_team_member_access_v1_team_member_access_get_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['team_member_actions_request'] is not None:
            _body_params = _params['team_member_actions_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization', 'ServerName Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseTeamMemberAccessResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/access/get', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def get_team_members_amount_v1_team_member_count_post(self, team_member_amount_request : TeamMemberAmountRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseInt:  # noqa: E501
        """Get Team Members amount  # noqa: E501

        This endpoint returns Team Members amount. Allowed for Admins / Portal Owners.  # noqa: E501

        :param team_member_amount_request: (required)
        :type team_member_amount_request: TeamMemberAmountRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_team_members_amount_v1_team_member_count_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.get_team_members_amount_v1_team_member_count_post_with_http_info(team_member_amount_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def get_team_members_amount_v1_team_member_count_post_with_http_info(self, team_member_amount_request : TeamMemberAmountRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Team Members amount  # noqa: E501

        This endpoint returns Team Members amount. Allowed for Admins / Portal Owners.  # noqa: E501

        :param team_member_amount_request: (required)
        :type team_member_amount_request: TeamMemberAmountRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'team_member_amount_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_team_members_amount_v1_team_member_count_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['team_member_amount_request'] is not None:
            _body_params = _params['team_member_amount_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseInt",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/count', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def get_team_members_v1_team_member_list_post(self, team_member_request : TeamMemberRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseListTeamMemberResponse:  # noqa: E501
        """Get Team Members  # noqa: E501

        This endpoint returns list of Team Members. Allowed for Admins / Portal Owners.  # noqa: E501

        :param team_member_request: (required)
        :type team_member_request: TeamMemberRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseListTeamMemberResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_team_members_v1_team_member_list_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.get_team_members_v1_team_member_list_post_with_http_info(team_member_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def get_team_members_v1_team_member_list_post_with_http_info(self, team_member_request : TeamMemberRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Team Members  # noqa: E501

        This endpoint returns list of Team Members. Allowed for Admins / Portal Owners.  # noqa: E501

        :param team_member_request: (required)
        :type team_member_request: TeamMemberRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseListTeamMemberResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'team_member_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_team_members_v1_team_member_list_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['team_member_request'] is not None:
            _body_params = _params['team_member_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization', 'ServerName Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseListTeamMemberResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/list', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def invite_team_member_v1_team_member_invite_post(self, invite_team_member_request : InviteTeamMemberRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseTeamMemberResponse:  # noqa: E501
        """Invite new Team Member  # noqa: E501

        This endpoint invites new Team Members. Allowed for Admins / Portal Owners.  # noqa: E501

        :param invite_team_member_request: (required)
        :type invite_team_member_request: InviteTeamMemberRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseTeamMemberResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the invite_team_member_v1_team_member_invite_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.invite_team_member_v1_team_member_invite_post_with_http_info(invite_team_member_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def invite_team_member_v1_team_member_invite_post_with_http_info(self, invite_team_member_request : InviteTeamMemberRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Invite new Team Member  # noqa: E501

        This endpoint invites new Team Members. Allowed for Admins / Portal Owners.  # noqa: E501

        :param invite_team_member_request: (required)
        :type invite_team_member_request: InviteTeamMemberRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseTeamMemberResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'invite_team_member_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invite_team_member_v1_team_member_invite_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['invite_team_member_request'] is not None:
            _body_params = _params['invite_team_member_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseTeamMemberResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/invite', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def remove_team_members_v1_team_member_delete_post(self, remove_team_member_request : RemoveTeamMemberRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseTeamMemberResponse:  # noqa: E501
        """Remove Team Member  # noqa: E501

        This endpoint removes Team Member. Allowed for Admins / Portal Owners.  # noqa: E501

        :param remove_team_member_request: (required)
        :type remove_team_member_request: RemoveTeamMemberRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseTeamMemberResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the remove_team_members_v1_team_member_delete_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.remove_team_members_v1_team_member_delete_post_with_http_info(remove_team_member_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def remove_team_members_v1_team_member_delete_post_with_http_info(self, remove_team_member_request : RemoveTeamMemberRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Remove Team Member  # noqa: E501

        This endpoint removes Team Member. Allowed for Admins / Portal Owners.  # noqa: E501

        :param remove_team_member_request: (required)
        :type remove_team_member_request: RemoveTeamMemberRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseTeamMemberResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'remove_team_member_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_team_members_v1_team_member_delete_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['remove_team_member_request'] is not None:
            _body_params = _params['remove_team_member_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseTeamMemberResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def resend_invitation_email_v1_team_member_email_resend_post(self, resend_invitation_email_request : ResendInvitationEmailRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseTeamMemberResponse:  # noqa: E501
        """Resend invitation email  # noqa: E501

        This endpoint resend invitation email to Team Members. Allowed for Admins / Portal Owners.  # noqa: E501

        :param resend_invitation_email_request: (required)
        :type resend_invitation_email_request: ResendInvitationEmailRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseTeamMemberResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the resend_invitation_email_v1_team_member_email_resend_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.resend_invitation_email_v1_team_member_email_resend_post_with_http_info(resend_invitation_email_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def resend_invitation_email_v1_team_member_email_resend_post_with_http_info(self, resend_invitation_email_request : ResendInvitationEmailRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Resend invitation email  # noqa: E501

        This endpoint resend invitation email to Team Members. Allowed for Admins / Portal Owners.  # noqa: E501

        :param resend_invitation_email_request: (required)
        :type resend_invitation_email_request: ResendInvitationEmailRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseTeamMemberResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'resend_invitation_email_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resend_invitation_email_v1_team_member_email_resend_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['resend_invitation_email_request'] is not None:
            _body_params = _params['resend_invitation_email_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseTeamMemberResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/email/resend', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def update_team_members_v1_team_member_update_post(self, update_team_member_request : UpdateTeamMemberRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> WrappedResponseTeamMemberResponse:  # noqa: E501
        """Update Team Member  # noqa: E501

        This endpoint updates Team Member. Allowed for Admins / Portal Owners.  # noqa: E501

        :param update_team_member_request: (required)
        :type update_team_member_request: UpdateTeamMemberRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseTeamMemberResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_team_members_v1_team_member_update_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.update_team_members_v1_team_member_update_post_with_http_info(update_team_member_request, origin, referer, **kwargs)  # noqa: E501

    @validate_arguments
    async def update_team_members_v1_team_member_update_post_with_http_info(self, update_team_member_request : UpdateTeamMemberRequest, origin : Annotated[Optional[StrictStr], Field(description="Origin header (required)")] = None, referer : Annotated[Optional[StrictStr], Field(description="Referer header (required if Origin missing)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Update Team Member  # noqa: E501

        This endpoint updates Team Member. Allowed for Admins / Portal Owners.  # noqa: E501

        :param update_team_member_request: (required)
        :type update_team_member_request: UpdateTeamMemberRequest
        :param origin: Origin header (required)
        :type origin: str
        :param referer: Referer header (required if Origin missing)
        :type referer: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseTeamMemberResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'update_team_member_request',
            'origin',
            'referer'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_team_members_v1_team_member_update_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['origin'] is not None:
            _header_params['origin'] = _params['origin']

        if _params['referer'] is not None:
            _header_params['referer'] = _params['referer']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_team_member_request'] is not None:
            _body_params = _params['update_team_member_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Bearer Authorization']  # noqa: E501

        _response_types_map = {
            '200': "WrappedResponseTeamMemberResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/v1/team_member/update', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
