# coding: utf-8

"""
    Mentortools

    Mentortools

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from apple_connector.models.asc_credentials import ASCCredentials
from apple_connector.models.content_rights_declaration import ContentRightsDeclaration
from apple_connector.models.iap_create_params import IAPCreateParams
from apple_connector.models.release_type import ReleaseType
from apple_connector.models.review_type import ReviewType
from apple_connector.models.subscription_status_url_version import SubscriptionStatusUrlVersion
from apple_connector.models.webhooks import Webhooks

class SetupAppParams(BaseModel):
    """
    SetupAppParams
    """
    credentials: ASCCredentials = Field(...)
    bundle_id: StrictStr = Field(...)
    description: StrictStr = Field(...)
    keywords: StrictStr = Field(...)
    marketing_url: Optional[StrictStr] = Field(default=None, alias="marketingUrl")
    support_url: Optional[StrictStr] = Field(default=None, alias="supportUrl")
    copyright: StrictStr = Field(...)
    version_string: Optional[StrictStr] = Field(default=None, alias="versionString")
    review_type: Optional[ReviewType] = Field(default=None, alias="reviewType")
    release_type: Optional[ReleaseType] = Field(default=None, alias="releaseType")
    earliest_release_date: Optional[StrictStr] = Field(default=None, alias="earliestReleaseDate")
    downloadable: Optional[StrictBool] = None
    name: Optional[StrictStr] = Field(...)
    secret: StrictStr = Field(...)
    url: StrictStr = Field(...)
    event_types: Optional[conlist(Webhooks)] = Field(default=None, alias="eventTypes")
    privacy_policy_url: StrictStr = Field(default=..., alias="privacyPolicyUrl")
    subtitle: Optional[StrictStr] = None
    privacy_choices_url: Optional[StrictStr] = Field(default=None, alias="privacyChoicesUrl")
    privacy_policy_text: Optional[StrictStr] = Field(default=None, alias="privacyPolicyText")
    iap_products: Optional[conlist(IAPCreateParams)] = None
    subscription_status_url: Optional[StrictStr] = Field(default=None, alias="subscriptionStatusUrl")
    subscription_status_url_for_sandbox: Optional[StrictStr] = Field(default=None, alias="subscriptionStatusUrlForSandbox")
    accessibility_url: Optional[StrictStr] = Field(default=None, alias="accessibilityUrl")
    bundle_id: Optional[StrictStr] = Field(default=None, alias="bundleId")
    streamlined_purchasing_enabled: Optional[StrictBool] = Field(default=None, alias="streamlinedPurchasingEnabled")
    subscription_status_url_version: Optional[SubscriptionStatusUrlVersion] = Field(default=None, alias="subscriptionStatusUrlVersion")
    subscription_status_url_version_for_sandbox: Optional[SubscriptionStatusUrlVersion] = Field(default=None, alias="subscriptionStatusUrlVersionForSandbox")
    content_rights_declaration: Optional[ContentRightsDeclaration] = Field(default=None, alias="contentRightsDeclaration")
    __properties = ["credentials", "bundle_id", "description", "keywords", "marketingUrl", "supportUrl", "copyright", "versionString", "reviewType", "releaseType", "earliestReleaseDate", "downloadable", "name", "secret", "url", "eventTypes", "privacyPolicyUrl", "subtitle", "privacyChoicesUrl", "privacyPolicyText", "iap_products", "subscriptionStatusUrl", "subscriptionStatusUrlForSandbox", "accessibilityUrl", "bundleId", "streamlinedPurchasingEnabled", "subscriptionStatusUrlVersion", "subscriptionStatusUrlVersionForSandbox", "contentRightsDeclaration"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SetupAppParams:
        """Create an instance of SetupAppParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of credentials
        if self.credentials:
            _dict['credentials'] = self.credentials.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in iap_products (list)
        _items = []
        if self.iap_products:
            for _item in self.iap_products:
                if _item:
                    _items.append(_item.to_dict())
            _dict['iap_products'] = _items
        # set to None if marketing_url (nullable) is None
        # and __fields_set__ contains the field
        if self.marketing_url is None and "marketing_url" in self.__fields_set__:
            _dict['marketingUrl'] = None

        # set to None if support_url (nullable) is None
        # and __fields_set__ contains the field
        if self.support_url is None and "support_url" in self.__fields_set__:
            _dict['supportUrl'] = None

        # set to None if version_string (nullable) is None
        # and __fields_set__ contains the field
        if self.version_string is None and "version_string" in self.__fields_set__:
            _dict['versionString'] = None

        # set to None if review_type (nullable) is None
        # and __fields_set__ contains the field
        if self.review_type is None and "review_type" in self.__fields_set__:
            _dict['reviewType'] = None

        # set to None if release_type (nullable) is None
        # and __fields_set__ contains the field
        if self.release_type is None and "release_type" in self.__fields_set__:
            _dict['releaseType'] = None

        # set to None if earliest_release_date (nullable) is None
        # and __fields_set__ contains the field
        if self.earliest_release_date is None and "earliest_release_date" in self.__fields_set__:
            _dict['earliestReleaseDate'] = None

        # set to None if downloadable (nullable) is None
        # and __fields_set__ contains the field
        if self.downloadable is None and "downloadable" in self.__fields_set__:
            _dict['downloadable'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if subtitle (nullable) is None
        # and __fields_set__ contains the field
        if self.subtitle is None and "subtitle" in self.__fields_set__:
            _dict['subtitle'] = None

        # set to None if privacy_choices_url (nullable) is None
        # and __fields_set__ contains the field
        if self.privacy_choices_url is None and "privacy_choices_url" in self.__fields_set__:
            _dict['privacyChoicesUrl'] = None

        # set to None if privacy_policy_text (nullable) is None
        # and __fields_set__ contains the field
        if self.privacy_policy_text is None and "privacy_policy_text" in self.__fields_set__:
            _dict['privacyPolicyText'] = None

        # set to None if iap_products (nullable) is None
        # and __fields_set__ contains the field
        if self.iap_products is None and "iap_products" in self.__fields_set__:
            _dict['iap_products'] = None

        # set to None if subscription_status_url (nullable) is None
        # and __fields_set__ contains the field
        if self.subscription_status_url is None and "subscription_status_url" in self.__fields_set__:
            _dict['subscriptionStatusUrl'] = None

        # set to None if subscription_status_url_for_sandbox (nullable) is None
        # and __fields_set__ contains the field
        if self.subscription_status_url_for_sandbox is None and "subscription_status_url_for_sandbox" in self.__fields_set__:
            _dict['subscriptionStatusUrlForSandbox'] = None

        # set to None if accessibility_url (nullable) is None
        # and __fields_set__ contains the field
        if self.accessibility_url is None and "accessibility_url" in self.__fields_set__:
            _dict['accessibilityUrl'] = None

        # set to None if bundle_id (nullable) is None
        # and __fields_set__ contains the field
        if self.bundle_id is None and "bundle_id" in self.__fields_set__:
            _dict['bundleId'] = None

        # set to None if streamlined_purchasing_enabled (nullable) is None
        # and __fields_set__ contains the field
        if self.streamlined_purchasing_enabled is None and "streamlined_purchasing_enabled" in self.__fields_set__:
            _dict['streamlinedPurchasingEnabled'] = None

        # set to None if content_rights_declaration (nullable) is None
        # and __fields_set__ contains the field
        if self.content_rights_declaration is None and "content_rights_declaration" in self.__fields_set__:
            _dict['contentRightsDeclaration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SetupAppParams:
        """Create an instance of SetupAppParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SetupAppParams.parse_obj(obj)

        _obj = SetupAppParams.parse_obj({
            "credentials": ASCCredentials.from_dict(obj.get("credentials")) if obj.get("credentials") is not None else None,
            "bundle_id": obj.get("bundle_id"),
            "description": obj.get("description"),
            "keywords": obj.get("keywords"),
            "marketing_url": obj.get("marketingUrl"),
            "support_url": obj.get("supportUrl"),
            "copyright": obj.get("copyright"),
            "version_string": obj.get("versionString"),
            "review_type": obj.get("reviewType"),
            "release_type": obj.get("releaseType"),
            "earliest_release_date": obj.get("earliestReleaseDate"),
            "downloadable": obj.get("downloadable"),
            "name": obj.get("name"),
            "secret": obj.get("secret"),
            "url": obj.get("url"),
            "event_types": obj.get("eventTypes"),
            "privacy_policy_url": obj.get("privacyPolicyUrl"),
            "subtitle": obj.get("subtitle"),
            "privacy_choices_url": obj.get("privacyChoicesUrl"),
            "privacy_policy_text": obj.get("privacyPolicyText"),
            "iap_products": [IAPCreateParams.from_dict(_item) for _item in obj.get("iap_products")] if obj.get("iap_products") is not None else None,
            "subscription_status_url": obj.get("subscriptionStatusUrl"),
            "subscription_status_url_for_sandbox": obj.get("subscriptionStatusUrlForSandbox"),
            "accessibility_url": obj.get("accessibilityUrl"),
            "bundle_id": obj.get("bundleId"),
            "streamlined_purchasing_enabled": obj.get("streamlinedPurchasingEnabled"),
            "subscription_status_url_version": obj.get("subscriptionStatusUrlVersion"),
            "subscription_status_url_version_for_sandbox": obj.get("subscriptionStatusUrlVersionForSandbox"),
            "content_rights_declaration": obj.get("contentRightsDeclaration")
        })
        return _obj


