# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from chat_server_connector.models.chat_message_type import ChatMessageType

class ChatMessage(BaseModel):
    """
    ChatMessage
    """
    text: StrictStr = Field(...)
    id: Optional[StrictInt] = None
    chat_id: StrictInt = Field(...)
    chat_member_id: StrictInt = Field(...)
    chat_session_id: Optional[StrictInt] = None
    is_hidden: Optional[StrictBool] = False
    inserted_by_member_id: Optional[StrictInt] = None
    chat_message_type: Optional[ChatMessageType] = None
    added_at: Optional[StrictInt] = None
    deleted_at: Optional[StrictInt] = None
    __properties = ["text", "id", "chat_id", "chat_member_id", "chat_session_id", "is_hidden", "inserted_by_member_id", "chat_message_type", "added_at", "deleted_at"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChatMessage:
        """Create an instance of ChatMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChatMessage:
        """Create an instance of ChatMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChatMessage.parse_obj(obj)

        _obj = ChatMessage.parse_obj({
            "text": obj.get("text"),
            "id": obj.get("id"),
            "chat_id": obj.get("chat_id"),
            "chat_member_id": obj.get("chat_member_id"),
            "chat_session_id": obj.get("chat_session_id"),
            "is_hidden": obj.get("is_hidden") if obj.get("is_hidden") is not None else False,
            "inserted_by_member_id": obj.get("inserted_by_member_id"),
            "chat_message_type": obj.get("chat_message_type"),
            "added_at": obj.get("added_at"),
            "deleted_at": obj.get("deleted_at")
        })
        return _obj


