#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import dataclasses
import typing
from typing import Protocol, runtime_checkable


@runtime_checkable
@dataclasses.dataclass
class DataclassProtocol(Protocol):
    pass


class PickableDict(dict):
    def pick(self, keys: typing.Iterable) -> dict:
        """Returns new dict with picked keys only"""
        return {k: self[k] for k in keys if k in self}
