# Init Helper
Tools to parse args, read config, init logs and etc

## Парсинг конфигов
### Создадим конфиг файл
```bash
printf 'some = 123\nother = "www"\nbar = "empty"' > example.toml
```
Проверим содержимое
```bash
cat example.toml
```
получим:
```toml
some = 123
other = "www"
bar = "empty"
```
### Считаем конфиг как экземпляр датакласса
#### Подготовим python файл, имитирующий чтение конфига и печатающий результат
```bash
printf '
import dataclasses
import init_helpers
@dataclasses.dataclass
class Config:
    other: str
    some: int = 42
    foo: float = 1.23    
    topics: tuple[str, ...] = ("one", )    
config = init_helpers.parse_arg_as_dataclass(Config)
print(config)
' > init.py
```
#### Запустим инициализацию, передав ей конфиг
```bash
python init.py example.toml
```
Получим
```text
Config(other='www', some=123, foo=1.23, topics=('one',))
```
#### Запустим инициализацию с конфигом и переопределив значения из конфига 
```bash
python init.py example.toml -v foo=4.2 -v some=42
```
Получим
```text
Config(other='www', some=42, foo=4.2, topics=('one',))
```
#### Запустим инициализацию без конфига, передав необходимые значения через аргументы запуска
```bash
python init.py example.toml -v other=qqq -v 'topics=["two","four"]'
```
Получим
```text
Config(other='qqq', some=123, foo=1.23, topics=('two', 'four'))
```