# deep-agent-sdk
FastAPI service for running deep agent video generation

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.1.0+2309671431
- Generator version: 7.19.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import deep_agent_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import deep_agent_sdk
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import deep_agent_sdk
from deep_agent_sdk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = deep_agent_sdk.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with deep_agent_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = deep_agent_sdk.HealthApi(api_client)

    try:
        # Health check
        api_response = await api_instance.health_check_health_get()
        print("The response of HealthApi->health_check_health_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling HealthApi->health_check_health_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*HealthApi* | [**health_check_health_get**](docs/HealthApi.md#health_check_health_get) | **GET** /health | Health check
*RunsApi* | [**create_run_runs_post**](docs/RunsApi.md#create_run_runs_post) | **POST** /runs | Create a new agent run


## Documentation For Models

 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HealthResponse](docs/HealthResponse.md)
 - [LocationInner](docs/LocationInner.md)
 - [RunCreateRequest](docs/RunCreateRequest.md)
 - [RunCreateResponse](docs/RunCreateResponse.md)
 - [ValidationError](docs/ValidationError.md)
 - [WrappedResponseHealthResponse](docs/WrappedResponseHealthResponse.md)
 - [WrappedResponseRunCreateResponse](docs/WrappedResponseRunCreateResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




