## EmailServiceV2Connector

Client for sending emails via EmailServiceV2

## Library Installation

```
pip install --extra-index-url https://pypi.abm-jsc.ru email-service-v2-connector-abm
```

## Quick Start


#### Send email using EmailServiceV2Connector
```python
import asyncio

import aiohttp 
from email_service_v2_connector import Email, EmailServiceV2Connector, SendPriority


async def send_email_using_email_service_v2_connector():
    
    session = aiohttp.ClientSession()

    email = Email(
        subject='Example Letter', 
        body='Dear Someone! If you get this letter, everything will be OK', 
        send_to=['someone@abm-jsc.ru'],
    )

    email_service_connector = EmailServiceV2Connector(
        config=EmailServiceV2Connector.Config(
            url='http://10.10.31.12/email_service_v2',
            server_name='immovable_server',
            sender_name='test_sender',
            timeout_sec=10,         
        ),
        context=EmailServiceV2Connector.Context(
            session=session,
        ),
    )

    await email_service_connector.send_email(email)

    await session.close()


asyncio.run(send_email_using_email_service_v2_connector())
```
