#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from abc import ABC, abstractmethod
from typing import Optional


class AbstractFileStorage(ABC):
    @abstractmethod
    async def save(self, content: bytes, relative_path: str, name: str, allow_rewrite: bool = False) -> None:
        pass

    @abstractmethod
    async def load(self, relative_path: str, name: str, offset: int = 0, size: int = -1) -> bytes:
        pass

    @abstractmethod
    async def delete(self, relative_path: str, name: str) -> None:
        pass

    @abstractmethod
    async def check_file_existence(self, relative_path: str, name: str) -> None:
        pass
