# #  Copyright (C) 2024
# #  ABM, Moscow
# #
# #  UNPUBLISHED PROPRIETARY MATERIAL.
# #  ALL RIGHTS RESERVED.
# #
# #  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
# import itertools
# from dataclasses import dataclass, field
# from typing import Any
#
# from run_markdown.utils import compare_exceptions
#
#
# @dataclass(frozen=True, slots=True)
# class Comparison:
#     index: str
#     expected: Any
#     method: str
#     actual: Any
#     exception: Exception | None = None
#     comma: bool = False
#
#     def to_str(self, depth: int = 1) -> str:
#         result = 'ok' if self.exception is None else f'FAIL: {self.exception!r}'
#         comma = ',' if self.comma else ''
#         return ' ' * depth + f'{self.index}{self.expected}{comma} /// {self.method} {self.actual} // {result}'
#
#     def __eq__(self, other: 'Comparison') -> bool:
#         if type(other) is not type(self):
#             return False
#         return (self.index == other.index
#                 and self.expected == other.expected
#                 and self.method == other.method
#                 and self.actual == other.actual
#                 and compare_exceptions(self.exception, other.exception))
#
#
# @dataclass
# class ComparisonBuffer:
#     prefix: str = ''
#     values: list['ComparisonBuffer | Comparison | Exception'] = field(default_factory=list)
#     postfix: str = ''
#
#     def __eq__(self, other: 'ComparisonBuffer') -> bool:
#         if type(other) is not type(self):
#             return False
#         values_are_equal = all([
#             compare_exceptions(left, right) if isinstance(left, Exception) else left == right
#             for left, right in itertools.zip_longest(self.values, other.values)
#         ])
#         return self.prefix == other.prefix and self.postfix == other.postfix and values_are_equal
#
#     def to_str(self, depth: int = -1) -> str:
#         lines = [' ' * depth + self.prefix] if self.prefix else []
#         lines += [
#             (value.to_str(depth + 1) if isinstance(value, ComparisonBuffer | Comparison) else f'FAIL: {repr(value)}')
#             for value in self.values
#         ]
#         lines += [' ' * depth + self.postfix] if self.prefix else []
#         return '\n'.join(lines)
#         # return '\n'.join([' ' + line for line in lines])
#
#     def print(self, depth: int = 0) -> None:
#         print(self.to_str(depth))
#
#     @property
#     def exception(self) -> Exception | None:
#         exceptions = []
#         for val in self.values:
#             if isinstance(val, Exception):
#                 exceptions.append(val)
#             elif isinstance(val, ComparisonBuffer | Comparison):
#                 if (exc := val.exception) is not None:
#                     exceptions.append(exc)
#         if exceptions:
#             return ExceptionGroup(self.prefix, exceptions)
#
#     def append(self, value: 'ComparisonBuffer | Comparison | Exception') -> None:
#         self.values.append(value)
