#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>, Alexander Medvedev <a.medvedev@abm-jsc.ru>

from enum import EnumMeta

from .thumbnail_processors.abstract_thumbnail_processor import AbstractThumbnailProcessor


class ThumbnailProvider:
    def __init__(self) -> None:
        self._file_extension_to_thumbnail_processor: dict[str, AbstractThumbnailProcessor] = {}

    def register(self, file_extensions: EnumMeta, thumbnail_processor: AbstractThumbnailProcessor) -> None:
        for file_extension in file_extensions:
            self._file_extension_to_thumbnail_processor[file_extension] = thumbnail_processor

    def get(self, file_extension: str) -> AbstractThumbnailProcessor | None:
        return self._file_extension_to_thumbnail_processor.get(file_extension)
