# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt
from chat_server_connector.models.chat_member_role_add import ChatMemberRoleAdd

class ChatMemberCreateOrUpdate(BaseModel):
    """
    ChatMemberCreateOrUpdate
    """
    user_id: StrictInt = Field(...)
    role: Optional[ChatMemberRoleAdd] = None
    is_removed: Optional[StrictBool] = False
    is_banned: Optional[StrictBool] = False
    __properties = ["user_id", "role", "is_removed", "is_banned"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChatMemberCreateOrUpdate:
        """Create an instance of ChatMemberCreateOrUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChatMemberCreateOrUpdate:
        """Create an instance of ChatMemberCreateOrUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChatMemberCreateOrUpdate.parse_obj(obj)

        _obj = ChatMemberCreateOrUpdate.parse_obj({
            "user_id": obj.get("user_id"),
            "role": obj.get("role"),
            "is_removed": obj.get("is_removed") if obj.get("is_removed") is not None else False,
            "is_banned": obj.get("is_banned") if obj.get("is_banned") is not None else False
        })
        return _obj


